% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{fineTune}
\alias{fineTune}
\alias{fineTune,PTSample-method}
\alias{fineTune<-}
\alias{fineTune<-,PTSample,numeric-method}
\title{Fine tune a PTSample}
\usage{
\S4method{fineTune}{PTSample}(sample)

\S4method{fineTune}{PTSample,numeric}(sample) <- value
}
\arguments{
\item{sample}{A \code{\link{PTSample}} for which the fine tune value
needs to be extracted or replace.}

\item{value}{A \code{numeric} value ranging from -8 up to 7, representing
the fine tune.}
}
\value{
For \code{fineTune} the fine tune value, represented by an
\code{integer} value ranging from -8 up to 7, is returned.

For \code{fineTune<-} A \code{\link{PTSample}} \code{sample}, updated
with the fine tune \code{value}, is returned.
}
\description{
Extract or replace the fine tune value of a \code{\link{PTSample}}.
}
\details{
\code{\link{PTSample}}s can be tuned with their fine tune values.
The values range from -8 up to 7 and affect the playback sample rate of
specific notes (see \code{\link{period_table}}). This method can be used
to extract this value, or to safely replace it.
}
\examples{
data("mod.intro")

## get the finetune of the first sample of mod.intro:

fineTune(PTSample(mod.intro, 1))

## Let's tweak the finetune of the first sample of
## mod.intro to -1:

fineTune(PTSample(mod.intro, 1)) <- -1
}
\author{
Pepijn de Vries
}
\seealso{
Other sample.operations: \code{\link{PTSample,PTModule,numeric-method}},
  \code{\link{PTSample,Wave,missing-method}},
  \code{\link{PTSample,raw,missing-method}},
  \code{\link{PTSample-method}}, \code{\link{PTSample<-}},
  \code{\link{PTSample<-,PTModule,numeric,PTSample-method}};
  \code{\link{PTSample}}, \code{\link{PTSample-class}};
  \code{\link{loopLength}},
  \code{\link{loopLength,PTSample-method}},
  \code{\link{loopLength<-}},
  \code{\link{loopLength<-,PTSample-method}};
  \code{\link{loopSample}},
  \code{\link{loopSample,PTSample-method}};
  \code{\link{loopStart}},
  \code{\link{loopStart,PTSample-method}},
  \code{\link{loopStart<-}},
  \code{\link{loopStart<-,PTSample-method}};
  \code{\link{loopState}},
  \code{\link{loopState,PTSample-method}};
  \code{\link{name}}, \code{\link{name,PTModule-method}},
  \code{\link{name,PTSample-method}}, \code{\link{name<-}},
  \code{\link{name<-,PTModule,character-method}},
  \code{\link{name<-,PTSample,character-method}};
  \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}};
  \code{\link{read.sample}},
  \code{\link{read.sample,character-method}};
  \code{\link{sampleLength}},
  \code{\link{sampleLength,PTSample-method}};
  \code{\link{volume}},
  \code{\link{volume,PTSample-method}},
  \code{\link{volume<-}},
  \code{\link{volume<-,PTSample,numeric-method}};
  \code{\link{waveform}},
  \code{\link{waveform,PTSample-method}},
  \code{\link{waveform<-}},
  \code{\link{waveform<-,PTSample-method}};
  \code{\link{write.sample}},
  \code{\link{write.sample,PTSample,character-method}}
}

