% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{available}
\alias{available}
\title{Providing values from the indicated column that occur at least once in one of the compared periods or in a given time interval}
\usage{
available(data, period1, period2, type = "prodID", interval = FALSE)
}
\arguments{
\item{data}{The user's data frame. It must contain a column \code{time} (as Date in format: year-month-day,e.g. '2020-12-01') and also a column indicated by the \code{type} parameter.}

\item{period1}{The first period (as character) limited to the year and month, e.g. "2019-03".}

\item{period2}{The second period (as character) limited to the year and month, e.g. "2019-04".}

\item{type}{This parameters defines the column which is used in the procedure. Possible values of the \code{type} parameter are: \code{retID}, \code{prodID}, \code{codeIN}, \code{codeOUT} or \code{description}.}

\item{interval}{A logical parameter indicating whether the procedure is to work for the whole time period between \code{period1} and \code{period2} (then it is TRUE).}
}
\value{
The function returns all values from the indicated column (defined by the \code{type} parameter) which occur at least once in one of the compared periods or in a given time interval. Possible values of the \code{type} parameter are: \code{retID}, \code{prodID}, \code{codeIN}, \code{codeOUT} or \code{description}. If the \code{interval} parameter is set to FALSE, then the function compares only periods defined by \code{period1} and \code{period2}. Otherwise the whole time period between \code{period1} and \code{period2} is considered.
}
\description{
The function returns all values from the indicated column (defined by the \code{type} parameter) which occur at least once in one of the compared periods or in a given time interval.
}
\examples{
available(milk, period1="2018-12", period2="2019-12", interval=TRUE)
available(milk, period1="2018-12", period2="2019-12", type="description")
}
