% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{summary.PrevMap.ps}
\alias{summary.PrevMap.ps}
\title{Summarizing fits of geostatistical linear models with preferentially sampled locations}
\usage{
\method{summary}{PrevMap.ps}(object, log.cov.pars = TRUE, ...)
}
\arguments{
\item{object}{an object of class "PrevMap.ps" obatained as result of a call to \code{\link{lm.ps.MCML}}.}

\item{log.cov.pars}{logical; if \code{log.cov.pars=TRUE} the estimates of the covariance parameters are given on the log-scale. Note that standard errors are also adjusted accordingly. Default is \code{log.cov.pars=TRUE}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A list with the following components

\code{coefficients.response}: matrix of the estimates, standard errors and p-values of the estimates of the regression coefficients for the response variable.

\code{coefficients.intensity}: matrix of the estimates, standard errors and p-values of the estimates of the regression coefficients for the sampling intenisty of the log-Gaussian process.

\code{cov.pars.response}: matrix of the estimates and standard errors of the covariance parameters for the Gaussian process associated with the response.

\code{cov.pars.intenisty}: matrix of the estimates and standard errors of the covariance parameters for the Gaussian process associated with the log-Gaussian process.

\code{log.lik}: value of likelihood function at the maximum likelihood estimates.

\code{kappa.response}: fixed value of the shape paramter of the Matern covariance function.

\code{call}: matched call.
}
\description{
\code{summary} method for the class "PrevMap" that computes the standard errors and p-values of likelihood-based model fits.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}
}
