/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.operator;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openfast.BitVectorBuilder;
import org.openfast.FieldValue;
import org.openfast.Global;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.template.Scalar;
import org.openfast.template.operator.ConstantOperatorCodec;
import org.openfast.template.operator.CopyOperatorCodec;
import org.openfast.template.operator.DefaultOperatorCodec;
import org.openfast.template.operator.DeltaDecimalOperatorCodec;
import org.openfast.template.operator.DeltaIntegerOperatorCodec;
import org.openfast.template.operator.DeltaStringOperatorCodec;
import org.openfast.template.operator.IncrementIntegerOperatorCodec;
import org.openfast.template.operator.NoneOperatorCodec;
import org.openfast.template.operator.Operator;
import org.openfast.template.operator.TailOperatorCodec;
import org.openfast.template.type.Type;
import org.openfast.util.Key;

public abstract class OperatorCodec
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map OPERATOR_MAP = new HashMap();
    protected static final OperatorCodec NONE_ALL = new NoneOperatorCodec(Operator.NONE, Type.ALL_TYPES);
    protected static final OperatorCodec CONSTANT_ALL = new ConstantOperatorCodec(Operator.CONSTANT, Type.ALL_TYPES);
    protected static final OperatorCodec DEFAULT_ALL = new DefaultOperatorCodec(Operator.DEFAULT, Type.ALL_TYPES);
    protected static final OperatorCodec COPY_ALL = new CopyOperatorCodec();
    protected static final OperatorCodec INCREMENT_INTEGER = new IncrementIntegerOperatorCodec(Operator.INCREMENT, Type.INTEGER_TYPES);
    protected static final OperatorCodec DELTA_INTEGER = new DeltaIntegerOperatorCodec(Operator.DELTA, Type.INTEGER_TYPES);
    protected static final OperatorCodec DELTA_STRING = new DeltaStringOperatorCodec();
    protected static final OperatorCodec DELTA_DECIMAL = new DeltaDecimalOperatorCodec();
    protected static final OperatorCodec TAIL = new TailOperatorCodec(Operator.TAIL, new Type[]{Type.ASCII, Type.STRING, Type.UNICODE, Type.BYTE_VECTOR});
    private final Operator operator;

    protected OperatorCodec(Operator operator, Type[] types) {
        this.operator = operator;
        int i = 0;
        while (i < types.length) {
            Key key = new Key(operator, types[i]);
            if (!OPERATOR_MAP.containsKey(key)) {
                OPERATOR_MAP.put(key, this);
            }
            ++i;
        }
    }

    public static OperatorCodec getCodec(Operator operator, Type type) {
        Key key = new Key(operator, type);
        if (!OPERATOR_MAP.containsKey(key)) {
            Global.handleError(FastConstants.S2_OPERATOR_TYPE_INCOMP, "The operator \"" + operator + "\" is not compatible with type \"" + type + "\"");
            throw new IllegalArgumentException();
        }
        return (OperatorCodec)OPERATOR_MAP.get(key);
    }

    public abstract ScalarValue getValueToEncode(ScalarValue var1, ScalarValue var2, Scalar var3);

    public abstract ScalarValue decodeValue(ScalarValue var1, ScalarValue var2, Scalar var3);

    public boolean isPresenceMapBitSet(byte[] encoding, FieldValue fieldValue) {
        return encoding.length != 0;
    }

    public abstract ScalarValue decodeEmptyValue(ScalarValue var1, Scalar var2);

    public boolean usesPresenceMapBit(boolean optional) {
        return true;
    }

    public ScalarValue getValueToEncode(ScalarValue value, ScalarValue priorValue, Scalar scalar, BitVectorBuilder presenceMapBuilder) {
        ScalarValue valueToEncode = this.getValueToEncode(value, priorValue, scalar);
        if (valueToEncode == null) {
            presenceMapBuilder.skip();
        } else {
            presenceMapBuilder.set();
        }
        return valueToEncode;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public boolean canEncode(ScalarValue value, Scalar field) {
        return true;
    }

    public boolean shouldDecodeType() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public String toString() {
        return this.operator.toString();
    }
}

