/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.portfolioeffect.quant.client.portfolio.ArrayCacheType;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ArrayCache {
    private File file;
    private int size;
    private RandomAccessFile stream = null;
    private int[] dimensions = new int[]{1};
    private boolean isAllZero = true;
    private boolean isAllNaN = true;
    private ArrayCacheType type;
    private int nanNumber = 0;
    private Lock lock = new ReentrantLock();
    private boolean isNaNFiltered = true;
    private boolean isNaN2Zero = false;
    private byte[] byteBufer = new byte[8];

    public ArrayCache(ArrayCacheType type) throws IOException {
        this.type = type;
        this.size = 0;
        this.file = File.createTempFile("quant", "tmp");
        this.file.deleteOnExit();
        this.stream = new RandomAccessFile(this.file, "rw");
    }

    private boolean checkAllNaN(double[] value) {
        boolean flag = true;
        int i = 0;
        while (i < value.length && flag) {
            flag = flag && Double.isNaN(value[i]);
            ++i;
        }
        return flag;
    }

    private boolean checkAllNaN(double[][] value) {
        boolean flag = true;
        int i = 0;
        while (i < value.length && flag) {
            int j = 0;
            while (i < value[i].length && flag) {
                flag = flag && Double.isNaN(value[i][j]);
                ++j;
            }
            ++i;
        }
        return flag;
    }

    private boolean checkAllNaN(float[] value) {
        boolean flag = true;
        int i = 0;
        while (i < value.length && flag) {
            flag = flag && Float.isNaN(value[i]);
            ++i;
        }
        return flag;
    }

    public ArrayCache(double[] value) throws IOException {
        this(ArrayCacheType.DOUBLE_VECTOR);
        this.isAllNaN = this.checkAllNaN(value);
        this.write(value);
    }

    public ArrayCache(String[] value) throws IOException {
        this(ArrayCacheType.STRING_VECTOR);
        this.write(value);
    }

    private void nanFilter(double value) {
        if (Double.isNaN(value)) {
            ++this.nanNumber;
        }
    }

    public ArrayCache(double[][] value) throws IOException {
        this(ArrayCacheType.DOUBLE_MATRIX);
        this.dimensions = new int[]{value[0].length};
        int i = 0;
        while (i < value.length) {
            this.write(value[i]);
            ++i;
        }
        this.isAllNaN = this.checkAllNaN(value);
    }

    public ArrayCache(float[] value) throws IOException {
        this(ArrayCacheType.DOUBLE_VECTOR);
        this.isAllNaN = this.checkAllNaN(value);
        this.writeAsDouble(value);
    }

    public ArrayCache(long[] value) throws IOException {
        this(ArrayCacheType.LONG_VECTOR);
        this.write(value);
    }

    public ArrayCache(int[] value) throws IOException {
        this(ArrayCacheType.LONG_VECTOR);
        this.writeAsLong(value);
    }

    public int getSize() {
        return this.size;
    }

    public double getNextDouble() throws IOException {
        if (this.type != ArrayCacheType.DOUBLE_VECTOR && this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        double x = this.readNextDouble();
        return x;
    }

    public void write(double[] value) throws IOException {
        this.lockToWrite();
        if (this.type != ArrayCacheType.DOUBLE_VECTOR && this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        double[] dArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            double e = dArray[n2];
            this.writeNextDouble(e);
            ++n2;
        }
        this.unlockToWrite();
    }

    public void write(double value) throws IOException {
        this.lockToWrite();
        if (this.type != ArrayCacheType.DOUBLE_VECTOR && this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.writeNextDouble(value);
        this.unlockToWrite();
    }

    public void writeNextLong(long value) throws IOException {
        ++this.size;
        this.isAllZero = this.isAllZero && value == 0L;
        int i = 7;
        while (i > 0) {
            this.byteBufer[i] = (byte)value;
            value >>>= 8;
            --i;
        }
        this.byteBufer[0] = (byte)value;
        this.stream.write(this.byteBufer);
    }

    public void writeNextDouble(double value) throws IOException {
        ++this.size;
        this.nanFilter(value);
        this.isAllNaN = this.isAllNaN && Double.isNaN(value);
        this.isAllZero = this.isAllZero && value == 0.0;
        long longValue = Double.doubleToRawLongBits(value);
        int i = 7;
        while (i > 0) {
            this.byteBufer[i] = (byte)longValue;
            longValue >>>= 8;
            --i;
        }
        this.byteBufer[0] = (byte)longValue;
        this.stream.write(this.byteBufer);
    }

    public long readNextLong() throws IOException {
        long value = 0L;
        this.stream.read(this.byteBufer);
        int i = 0;
        while (i < 8) {
            value <<= 8;
            value ^= (long)(this.byteBufer[i] & 0xFF);
            ++i;
        }
        return value;
    }

    public double readNextDouble() throws IOException {
        return Double.longBitsToDouble(this.readNextLong());
    }

    public void write(String[] value) throws IOException {
        this.lockToWrite();
        if (this.type != ArrayCacheType.STRING_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        byte[] splitSymbol = new String("#-#").getBytes();
        String[] stringArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            this.stream.write(e.getBytes());
            this.stream.write(splitSymbol);
            ++n2;
        }
        this.unlockToWrite();
    }

    public void writeAsDouble(float[] value) throws IOException {
        this.lockToWrite();
        if (this.type != ArrayCacheType.DOUBLE_VECTOR && this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        int i = 0;
        while (i < value.length) {
            double x = value[i];
            this.writeNextDouble(x);
            ++i;
        }
        this.unlockToWrite();
    }

    public void writeAsLong(int[] value) throws IOException {
        this.lockToWrite();
        if (this.type != ArrayCacheType.LONG_VECTOR && this.type != ArrayCacheType.LONG_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        int[] nArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            this.writeNextLong(e);
            ++n2;
        }
        this.unlockToWrite();
    }

    public void write(long[] value) throws IOException {
        this.lockToWrite();
        if (this.type != ArrayCacheType.LONG_VECTOR && this.type != ArrayCacheType.LONG_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        long[] lArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            long e = lArray[n2];
            this.writeNextLong(e);
            ++n2;
        }
        this.unlockToWrite();
    }

    public void writeNextLong(long[] value) throws IOException {
        long[] lArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            long e = lArray[n2];
            this.writeNextLong(e);
            ++n2;
        }
    }

    public double[] getDoubleArray() throws IOException {
        this.lockToRead();
        if (this.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        double[] value = this.isNaNFiltered ? new double[this.size - this.nanNumber] : new double[this.size];
        int i = 0;
        int j = 0;
        while (i < this.size) {
            double x = this.readNextDouble();
            if (!this.isNaNFiltered || !Double.isNaN(x)) {
                if (this.isNaN2Zero && Double.isNaN(x)) {
                    x = 0.0;
                }
                value[j++] = x;
            }
            ++i;
        }
        this.unlockToRead();
        return value;
    }

    public float[] getDoubleAsFloatArray() throws IOException {
        this.lockToRead();
        if (this.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        float[] value = this.isNaNFiltered ? new float[this.size - this.nanNumber] : new float[this.size];
        int i = 0;
        int j = 0;
        while (i < this.size) {
            float x = (float)this.readNextDouble();
            if (!this.isNaNFiltered || !Double.isNaN(x)) {
                if (this.isNaN2Zero && Double.isNaN(x)) {
                    x = 0.0f;
                }
                value[j++] = x;
            }
            ++i;
        }
        this.unlockToRead();
        return value;
    }

    public long[] getDoubleAsLongArray() throws IOException {
        this.lockToRead();
        if (this.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        long[] value = this.isNaNFiltered ? new long[this.size - this.nanNumber] : new long[this.size];
        int i = 0;
        int j = 0;
        while (i < this.size) {
            long x = (long)this.readNextDouble();
            if (!this.isNaNFiltered || !Double.isNaN(x)) {
                if (this.isNaN2Zero && Double.isNaN(x)) {
                    x = 0L;
                }
                value[j++] = x;
            }
            ++i;
        }
        this.unlockToRead();
        return value;
    }

    public String[] getStringArray() throws IOException {
        this.lockToRead();
        if (this.type != ArrayCacheType.STRING_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        byte[] buffer = new byte[(int)this.stream.length()];
        this.stream.read(buffer);
        String[] value = new String(buffer).split("#-#");
        this.unlockToRead();
        return value;
    }

    public double[][] getDoubleMatrix() throws IOException {
        this.lockToRead();
        if (this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        if (this.dimensions.length != 1) {
            throw new RuntimeException("Wrong format of result data.");
        }
        double[][] value = new double[this.size / this.dimensions[0]][this.dimensions[0]];
        int i = 0;
        while (i < value.length) {
            int j = 0;
            while (j < value[0].length) {
                value[i][j] = this.readNextDouble();
                ++j;
            }
            ++i;
        }
        this.unlockToRead();
        return value;
    }

    public int[] getIntArray() throws IOException {
        this.lockToRead();
        if (this.type != ArrayCacheType.LONG_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        int[] value = new int[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = (int)this.readNextLong();
            ++i;
        }
        this.unlockToRead();
        return value;
    }

    public double[] getIntAsDoubleArray() throws IOException {
        this.lockToRead();
        if (this.type != ArrayCacheType.LONG_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        double[] value = new double[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = this.readNextLong();
            ++i;
        }
        this.unlockToRead();
        return value;
    }

    public long[] getLongArray(ArrayCache valuesCache) throws IOException {
        this.lockToRead();
        valuesCache.lockToRead();
        if (this.type != ArrayCacheType.LONG_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        if (valuesCache.type != ArrayCacheType.DOUBLE_VECTOR) {
            long[] value = new long[this.size];
            int i = 0;
            while (i < this.size) {
                value[i] = this.readNextLong();
                ++i;
            }
            this.unlockToRead();
            valuesCache.unlockToRead();
            return value;
        }
        long[] value = valuesCache.isNaNFiltered ? new long[this.size - valuesCache.nanNumber] : new long[this.size];
        int i = 0;
        int j = 0;
        while (i < this.size) {
            long t = this.readNextLong();
            double x = valuesCache.readNextDouble();
            if (!valuesCache.isNaNFiltered || !Double.isNaN(x)) {
                value[j++] = t;
            }
            ++i;
        }
        valuesCache.unlockToRead();
        this.unlockToRead();
        return value;
    }

    public long[] getLongArray() throws IOException {
        this.lockToRead();
        if (this.type != ArrayCacheType.LONG_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        long[] value = new long[this.size];
        int i = 0;
        while (i < this.size) {
            value[i] = this.readNextLong();
            ++i;
        }
        this.unlockToRead();
        return value;
    }

    public static ArrayCache[] splitBatchDouble(ArrayCache value, int batchSize) throws IOException {
        if (value.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[batchSize];
        int i = 0;
        while (i < batchSize) {
            batchValue[i] = new ArrayCache(ArrayCacheType.DOUBLE_VECTOR);
            ++i;
        }
        int len = 0;
        value.lockToRead();
        while (len < value.size) {
            int k = 0;
            while (k < batchSize) {
                double x = value.readNextDouble();
                if (Double.isNaN(x)) {
                    ++batchValue[k].nanNumber;
                }
                batchValue[k].isAllZero = batchValue[k].isAllZero && x == 0.0;
                batchValue[k].writeNextDouble(x);
                ++len;
                ++k;
            }
        }
        value.unlockToRead();
        return batchValue;
    }

    public static ArrayCache[] splitBatchDouble(ArrayCache value) throws IOException {
        if (value.type != ArrayCacheType.DOUBLE_VECTOR && value.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[value.dimensions.length];
        int i = 0;
        while (i < value.dimensions.length) {
            batchValue[i] = value.dimensions[i] == 1 ? new ArrayCache(ArrayCacheType.DOUBLE_VECTOR) : new ArrayCache(ArrayCacheType.DOUBLE_MATRIX);
            batchValue[i].setDimensions(new int[]{value.dimensions[i]});
            ++i;
        }
        int len = 0;
        value.lockToRead();
        while (len < value.size) {
            int k = 0;
            while (k < value.dimensions.length) {
                int m = 0;
                while (m < value.dimensions[k]) {
                    double x = value.readNextDouble();
                    boolean bl = batchValue[k].isAllZero = batchValue[k].isAllZero && x == 0.0;
                    if (Double.isNaN(x)) {
                        ++batchValue[k].nanNumber;
                    }
                    batchValue[k].writeNextDouble(x);
                    ++len;
                    ++m;
                }
                ++k;
            }
        }
        value.unlockToRead();
        return batchValue;
    }

    public static ArrayCache[] splitBatchDoubleToInt(ArrayCache value, int batchSize) throws IOException {
        if (value.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[batchSize];
        int i = 0;
        while (i < batchSize) {
            batchValue[i] = new ArrayCache(ArrayCacheType.LONG_VECTOR);
            ++i;
        }
        int len = 0;
        value.lockToRead();
        while (len < value.size) {
            int k = 0;
            while (k < batchSize) {
                int x = (int)value.readNextDouble();
                batchValue[k].isAllZero = batchValue[k].isAllZero && (double)x == 0.0;
                batchValue[k].writeNextLong(x);
                ++len;
                ++k;
            }
        }
        value.unlockToRead();
        return batchValue;
    }

    public static ArrayCache[] splitBatchDoubleMatrixToInt(ArrayCache value) throws IOException {
        if (value.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[value.dimensions[0]];
        int i = 0;
        while (i < value.dimensions[0]) {
            batchValue[i] = new ArrayCache(ArrayCacheType.LONG_VECTOR);
            ++i;
        }
        int len = 0;
        value.lockToRead();
        while (len < value.size) {
            int k = 0;
            while (k < value.dimensions[0]) {
                int x = (int)value.readNextDouble();
                batchValue[k].isAllZero = batchValue[k].isAllZero && (double)x == 0.0;
                batchValue[k].writeNextLong(x);
                ++len;
                ++k;
            }
        }
        value.unlockToRead();
        return batchValue;
    }

    public static ArrayCache[] splitBatchDoubleMatrixToInt(ArrayCache value, int n) throws IOException {
        if (value.type != ArrayCacheType.DOUBLE_MATRIX && value.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[n];
        int i = 0;
        while (i < n) {
            batchValue[i] = new ArrayCache(ArrayCacheType.LONG_VECTOR);
            ++i;
        }
        int len = 0;
        value.lockToRead();
        while (len < value.size) {
            int k = 0;
            while (k < n) {
                int x = (int)value.readNextDouble();
                batchValue[k].isAllZero = batchValue[k].isAllZero && (double)x == 0.0;
                batchValue[k].writeNextLong(x);
                ++len;
                ++k;
            }
        }
        value.unlockToRead();
        return batchValue;
    }

    public static ArrayCache copyArrayCacheLong(ArrayCache value) throws IOException {
        ArrayCache batchValue = new ArrayCache(value.type);
        value.lockToRead();
        int k = 0;
        while (k < value.size) {
            long x = value.readNextLong();
            batchValue.isAllZero = batchValue.isAllZero && (double)x == 0.0;
            batchValue.writeNextLong(x);
            ++k;
        }
        value.unlockToRead();
        return batchValue;
    }

    protected void finalize() throws Throwable {
        if (this.stream != null) {
            this.stream.close();
        }
        this.file.delete();
        this.file = null;
        super.finalize();
    }

    public void delete() throws Throwable {
        if (this.stream != null) {
            this.stream.close();
        }
        this.file.delete();
        this.file = null;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int[] dimensions) {
        if (dimensions != null) {
            this.dimensions = dimensions;
        }
        if (dimensions.length == 1 && dimensions[0] > 1) {
            this.type = ArrayCacheType.DOUBLE_MATRIX;
        }
    }

    public boolean isAllZero() {
        return this.isAllZero;
    }

    public boolean isNaNFiltered() {
        return this.isNaNFiltered;
    }

    public void setNaNFiltered(boolean isNaNFiltered) {
        this.isNaNFiltered = isNaNFiltered;
    }

    public boolean isNaN2Zero() {
        return this.isNaN2Zero;
    }

    public void setNaN2Zero(boolean isNaN2Zero) {
        this.isNaN2Zero = isNaN2Zero;
    }

    public ArrayCacheType getType() {
        return this.type;
    }

    public int getNanNumber() {
        return this.nanNumber;
    }

    public void lockToRead() throws IOException {
        this.lock.lock();
        if (this.stream == null) {
            this.stream = new RandomAccessFile(this.file, "rw");
        }
        this.stream.seek(0L);
    }

    public void unlockToRead() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.stream = null;
        this.lock.unlock();
    }

    public void lockToWrite() throws IOException {
        this.lock.lock();
        if (this.stream == null) {
            this.stream = new RandomAccessFile(this.file, "rw");
        }
        this.stream.seek(this.stream.length());
    }

    public void unlockToWrite() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        this.stream = null;
        this.lock.unlock();
    }

    public boolean isAllNaN() {
        if (this.type == ArrayCacheType.DOUBLE_VECTOR) {
            return this.isAllNaN;
        }
        if (this.type == ArrayCacheType.DOUBLE_MATRIX) {
            return this.isAllNaN;
        }
        return false;
    }
}

