% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_GEX_clonotype_clusters_circos.R
\name{VDJ_GEX_clonotype_clusters_circos}
\alias{VDJ_GEX_clonotype_clusters_circos}
\title{Makes a Circos plot from the VDJ_GEX_integrate output. Connects the clonotypes with the corresponding clusters.}
\usage{
VDJ_GEX_clonotype_clusters_circos(
  VGM,
  topX,
  label.threshold,
  axis,
  c.threshold,
  c.count.label,
  c.count.label.size,
  n_cluster,
  platypus.version,
  gene.label,
  gene.label.size,
  arr.col,
  arr.direction,
  platy.theme,
  clonotype.column
)
}
\arguments{
\item{VGM}{The output of the VDJ_GEX_matrix function (VDJ_GEX_matrix.output[[1]]) has to be supplied. For Platypus v2: The output of the VDJ_GEX_integrate function (Platypus platypus.version v2). A list of data frames for each sample containing the clonotype information and cluster membership information.}

\item{topX}{Filters for the top X clonotypes and only plots the respective gene combinations or cluster memberships.}

\item{label.threshold}{Genes are only labeled if the count is larger then the label.threshold. By default all label.threshold = 0 (all genes are labeled).}

\item{axis}{Character. Axis scaling. Defaults to "max". Passed to VDJ_circos}

\item{c.threshold}{Only clonotypes are considered with a frequency higher then c.threshold. Allows to filter for only highly expanded clonotypes.}

\item{c.count.label}{Boolean, lets the user decide if the gene and count labels should be plotted or not. Default = T.}

\item{c.count.label.size}{Determines the font size of the gene labels. By default the font size for count labels is 0.6.}

\item{n_cluster}{Integer. No default.}

\item{platypus.version}{Input version to use. Defaults to "v3" for VDJ_GEX_matrix input}

\item{gene.label}{Boolean, lets the user decide if the gene labels should be plotted or not.}

\item{gene.label.size}{Determines the font size of the gene labels. By default the labelsize is automatically adjusted to 0.7 for labels with two or less digits, 0.6 for labels between 2 and 6 digits, and 0.4 for all longer labels. A manually defined font size will be the same for all labels!}

\item{arr.col}{Data.frame with three columns where the first two indicate the names of genes, clonotypes or clusters to be connected, and the third corresponds to the color of the arrow. Default set to data.frame(c("dummy.clonotype"), c("dummy.cluster"), c("dummy.color")), so no arrow is drawn.}

\item{arr.direction}{Either 1 or -1 and determines the direction of the arrow. Default=1.}

\item{platy.theme}{Allows plotting in the new "pretty" theme or the older "spiky" theme without group labels and radial arrangement of gene.labels. Default = "pretty".}

\item{clonotype.column}{Which column in VGM contains the clonotyping information? Default="clonotype_id_10X".}
}
\value{
Returns a circos plot and a list object with the following elememts for N samples: [[1 to N]] The first N listelements corresponds to the recorded circos plots for N beeing the number or samples in the VGM. Since Circlize uses the R base plotting funciton, this is not a ggplot object but can still be replotted by calling the first list element. [[N+1]] Adjacency matrix forwarded to VDJ_circos(). This Matrix contains the counts and can be used for manual replotting using VDJ_circos directly. [[N+2]] Contains a named list with colors for each connection drawn and can be used for manual replotting using VDJ_circos directly. [[N+3]] Contains a named list with grouping information and can be used for manual replotting using VDJ_circos directly.
}
\description{
Makes a Circos plot from the VDJ_GEX_integrate output. Connects the clonotypes with the corresponding clusters.
}
\examples{
\dontrun{
 clonotype.clusters <- VDJ_GEX_clonotype_clusters_circos(vgm[[1]], n_cluster=8, topX = 20)
 # print circos plot:
 clonotype.clusters[[1]]
}

}
