% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntibodyForests_expand_intermediates.R
\name{AntibodyForests_expand_intermediates}
\alias{AntibodyForests_expand_intermediates}
\title{Infer intermediate nodes in the minimum spanning trees/ sequences similiarity networks created by the AntibodyForests function}
\usage{
AntibodyForests_expand_intermediates(trees, parallel)
}
\arguments{
\item{trees}{AntibodyForests object/list of AntibodyForests objects - the resulting sequence similarity or minimum spanning tree networks from the AntibodyForests function.}

\item{parallel}{boolean - whether to execute the main subroutine in parallel or not. Requires the 'parallel' R package.}
}
\value{
nested list of AntibodyForests objects or single AntibodyForests object, with the resulting networks having expanded/inferred intermediate nodes.
}
\description{
Intermediate nodes are expanded/inferred based on the edge weight between two existing nodes: for example, of node 1 and node 2 are connected by an edge of weight = 3, 2 new nodes are added in-between and all resulting edges have weight = 1.
}
\examples{
\dontrun{
AntibodyForests_expand_intermediates(trees)
}
}
