% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Projection.R
\name{Projection}
\alias{Projection}
\title{R6 class representing a projection}
\description{
A projection on a line \code{D} parallel to another line
\code{Delta} is given by the line of projection (\code{D})
and the directrix line (\code{Delta}).
}
\note{
For an orthogonal projection, you can use the \code{projection}
method of the \code{\link{Line}} R6 class.
}
\examples{

## ------------------------------------------------
## Method `Projection$new`
## ------------------------------------------------

D <- Line$new(c(1,1), c(5,5))
Delta <- Line$new(c(0,0), c(3,4))
Projection$new(D, Delta)

## ------------------------------------------------
## Method `Projection$project`
## ------------------------------------------------

D <- Line$new(c(1,1), c(5,5))
Delta <- Line$new(c(0,0), c(3,4))
P <- Projection$new(D, Delta)
M <- c(1,3)
Mprime <- P$project(M)
D$includes(Mprime) # should be TRUE
Delta$isParallel(Line$new(M, Mprime)) # should be TRUE

## ------------------------------------------------
## Method `Projection$getMatrix`
## ------------------------------------------------

P <- Projection$new(Line$new(c(2,2), c(4,5)), Line$new(c(0,0), c(1,1)))
M <- c(1,5)
P$project(M)
P$getMatrix() \%*\% c(M,1)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{D}}{get or set the projection line}

\item{\code{Delta}}{get or set the directrix line}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Projection-new}{\code{Projection$new()}}
\item \href{#method-Projection-print}{\code{Projection$print()}}
\item \href{#method-Projection-project}{\code{Projection$project()}}
\item \href{#method-Projection-transform}{\code{Projection$transform()}}
\item \href{#method-Projection-getMatrix}{\code{Projection$getMatrix()}}
\item \href{#method-Projection-asAffine}{\code{Projection$asAffine()}}
\item \href{#method-Projection-clone}{\code{Projection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projection-new"></a>}}
\if{latex}{\out{\hypertarget{method-Projection-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Projection} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projection$new(D, Delta)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{D, Delta}}{two \code{Line} objects such that the two lines meet
(not parallel); or \code{Delta = NULL} for orthogonal projection onto
\code{D}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Projection} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{D <- Line$new(c(1,1), c(5,5))
Delta <- Line$new(c(0,0), c(3,4))
Projection$new(D, Delta)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projection-print"></a>}}
\if{latex}{\out{\hypertarget{method-Projection-print}{}}}
\subsection{Method \code{print()}}{
Show instance of a projection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projection$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projection-project"></a>}}
\if{latex}{\out{\hypertarget{method-Projection-project}{}}}
\subsection{Method \code{project()}}{
Project a point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projection$project(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{D <- Line$new(c(1,1), c(5,5))
Delta <- Line$new(c(0,0), c(3,4))
P <- Projection$new(D, Delta)
M <- c(1,3)
Mprime <- P$project(M)
D$includes(Mprime) # should be TRUE
Delta$isParallel(Line$new(M, Mprime)) # should be TRUE
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projection-transform"></a>}}
\if{latex}{\out{\hypertarget{method-Projection-transform}{}}}
\subsection{Method \code{transform()}}{
An alias of \code{project}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projection$transform(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projection-getMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-Projection-getMatrix}{}}}
\subsection{Method \code{getMatrix()}}{
Augmented matrix of the projection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projection$getMatrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 3x3 matrix.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{P <- Projection$new(Line$new(c(2,2), c(4,5)), Line$new(c(0,0), c(1,1)))
M <- c(1,5)
P$project(M)
P$getMatrix() \%*\% c(M,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projection-asAffine"></a>}}
\if{latex}{\out{\hypertarget{method-Projection-asAffine}{}}}
\subsection{Method \code{asAffine()}}{
Convert the reference projection to an \code{Affine}
object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projection$asAffine()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Projection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Projection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Projection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
