% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Translation.R
\name{Translation}
\alias{Translation}
\title{R6 class representing a translation}
\description{
A translation is given by a vector \code{v}.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{v}}{get or set the vector of translation}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Translation-new}{\code{Translation$new()}}
\item \href{#method-Translation-print}{\code{Translation$print()}}
\item \href{#method-Translation-project}{\code{Translation$project()}}
\item \href{#method-Translation-transform}{\code{Translation$transform()}}
\item \href{#method-Translation-translateLine}{\code{Translation$translateLine()}}
\item \href{#method-Translation-transformLine}{\code{Translation$transformLine()}}
\item \href{#method-Translation-translateEllipse}{\code{Translation$translateEllipse()}}
\item \href{#method-Translation-transformEllipse}{\code{Translation$transformEllipse()}}
\item \href{#method-Translation-getMatrix}{\code{Translation$getMatrix()}}
\item \href{#method-Translation-asAffine}{\code{Translation$asAffine()}}
\item \href{#method-Translation-clone}{\code{Translation$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-new"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Translation} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$new(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{a numeric vector of length two, the vector of translation}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Translation} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-print"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-print}{}}}
\subsection{Method \code{print()}}{
Show instance of a translation object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-project"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-project}{}}}
\subsection{Method \code{project()}}{
Transform a point or several points by the reference
translation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$project(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point or a two-column matrix of points, one point per row}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-transform"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-transform}{}}}
\subsection{Method \code{transform()}}{
An alias of \code{translate}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$transform(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point or a two-column matrix of points, one point per row}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-translateLine"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-translateLine}{}}}
\subsection{Method \code{translateLine()}}{
Translate a line.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$translateLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-transformLine"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-transformLine}{}}}
\subsection{Method \code{transformLine()}}{
An alias of \code{translateLine}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$transformLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-translateEllipse"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-translateEllipse}{}}}
\subsection{Method \code{translateEllipse()}}{
Translate a circle or an ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$translateEllipse(ell)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ell}}{an \code{Ellipse} object or a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{Ellipse} object or a \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-transformEllipse"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-transformEllipse}{}}}
\subsection{Method \code{transformEllipse()}}{
An alias of \code{translateEllipse}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$transformEllipse(ell)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ell}}{an \code{Ellipse} object or a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{Ellipse} object or a \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-getMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-getMatrix}{}}}
\subsection{Method \code{getMatrix()}}{
Augmented matrix of the translation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$getMatrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 3x3 matrix.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-asAffine"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-asAffine}{}}}
\subsection{Method \code{asAffine()}}{
Convert the reference translation to an \code{Affine}
object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$asAffine()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Translation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Translation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Translation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
