% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Pijavski}
\alias{Pijavski}
\title{Global univariate minimization of Lipschitz functions using Pijavski method}
\usage{
Pijavski( fn, Lips, a, b, iter, prec, env)
}
\arguments{
\item{fn}{input, a pointer to the objective function fn}
\item{Lips}{input, an overestimate of the Lipschitz constant of fn}
\item{a,b}{input, left and right boundaries of the interval of minimization}
\item{iter}{input and output, the maximum number of function evaluations, on return, the number of iterations made}
\item{prec}{input and output, the desired precision in terms of the value of fn, on return the difference between best fn and the lower estimate on the minimum. If negative, the Lipschitz constant is too small}
\item{env}{input, environment variable passed from R containing a reference to fn, should be defined as  new.env(list(fn = myfunction))}
}
\value{
  A list with components
  \item{x}{The global minimizer of fn.}
  \item{value}{The final value of the function being optimized.}
  \item{precision}{The precision of the result in terms of the difference of value and the lower estimate on fn.}
  \item{iterations}{Number of function evaluations performed.}
}
\description{
Pijavski  performs global univariate optimization of a Lipschitz function fn.
The return value is a list containing x,val=fn(x), precision reached and number of iterations made.
Pijavski code in C++ is being called from R environment with multiple arguments
}
\author{Gleb Beliakov and Gita Das}
\examples{
 optimize_funcR <- function(x,y)\{
   y <- x * x
   return(y)
 \}

 output<-Pijavski(optimize_funcR, 5, -2.0, 1.0, 1000, 10^-3,
         new.env(list(fn = optimize_funcR)))
 output

# named parameters
 output<-Pijavski(fn= optimize_funcR, Lips=4, a=-2.0, b=1.0, 
    iter=1000, prec=10^-3, env=new.env(list(fn = optimize_funcR)))

 output
}



\keyword{optimize}

