% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_lfc_reverse}
\alias{data_lfc_reverse}
\title{Lower Fraser Coho for Reverse Capture-Recapture with geographic stratification.}
\format{
\code{data_lfc_reverse}
A data frame with many rows and 4 columns

\describe{
\item{\code{cap_hist}.}{Capture history with possible histories as noted below}
\item{\code{freq}.}{Number of fish with this history.}
\item{\code{SE}.}{SE of the number of fish with this history. Only available for total escapement to C, L, N}
}
}
\usage{
data(data_lfc_reverse)
}
\description{
This is the data provided by Kaitlyn Dionne, DFO.
Arbeider et al (2020) proposed to estimate the run size of Lower Fraser River Coho (LFC) using a geographically stratified reverse-capture
method. Briefly, a LFC coho swim upstream, they are sampled near New Westminister, BC, which is downstream from several major rivers up which
are large spawning populations. These sample fish are assigned to the spawning population using genetic and other methods. These
spawning populations are identified as the Chilliwack Hatchery (denoted \emph{C}), the Lilloet River natural spawning population (denoted \emph{L}),
the Nicomen Slough population (denote \emph{N}) and all other population (denoted as \emph{0}). Notice that the sample fish at New Westminister
are NOT physically tagged, and population assignment is through genetic and other measures.
The upstream migration extends over two months (September to October) and is divided into 3 temporal strata corresponding
to \emph{Early} (denoted \emph{1E}), \emph{Peak} (denoted \emph{2P}) and \emph{Late} (denoted \emph{3L}). The digits 1, 2, 3 in front of the codes ensures
that the temporal strata are sorted temporally, but this is merely a convenience and does not affect the results.
The spawning populations at \emph{C}, \emph{L}, and \emph{N} are estimated by a variety of methods (see Arbeider, et al. 2020).
Each of the population estimates also has an estimated (which will be ignored for now).
}
\keyword{datasets}
