% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LP_IS_print.R
\name{LP_IS_print}
\alias{LP_IS_print}
\title{Print the results from a fit a Lincoln-Petersen Model with incomplete stratification}
\usage{
LP_IS_print(IS.results)
}
\arguments{
\item{IS.results}{Results from fitting an incomplete stratification model}
}
\value{
A nicely formatted report showing the results of the fit.
\itemize{
\item Model information (summary of arguments, model name, negative log-likelihood, number of parameters, AICc)
\item Raw data used in the fit (history, frequency,categories)
\item Initial values used in the optimization of the likelihood for the parameters
\item Design matrix and offset values for the parameters
\item Maximum likelihood estimates for the parameters and estimated abundance by category
\item SE for the above
\item Observed and expected counts for each capture history
\item Residual plot constructed from the previous observed and expected counts
}
}
\description{
Print the results from a fit a Lincoln-Petersen Model with incomplete stratification
}
\examples{

data(data_wae_is_short)
res <- Petersen::LP_IS_fit(data=data_wae_is_short, p_model=~-1 + ..cat:..time)
LP_IS_print(res)

}
