% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bradleyTerry.R
\name{bradleyTerry}
\alias{bradleyTerry}
\title{Computes the MLE for the BT model using an MM algorithm}
\usage{
bradleyTerry(conf.mat, initial = NA, baseline = NA, stop.dif = 0.001)
}
\arguments{
\item{conf.mat}{a matrix of conf.mat class. An N-by-N conflict matrix whose \code{(i,j)}th element is the number of times i defeated j.}

\item{initial}{initial values of dominance indices for the MM algorithm, if not supplied, the 0 vector will be the inital value.}

\item{baseline}{index for agent to represent baseline dominance index set to 0.  If NA, the "sum-to-one" parameterization will be used.}

\item{stop.dif}{numeric value for difference in log likelihood value between iterations.  Used as the convergence criterion for the algorithm.}
}
\value{
A list of length 3. 
 \item{domInds}{a vector of length N consiting of the MLE values of the dominance indices. Lower values represent lower ranks.}
 \item{probMat}{an N-by-N numeric matrix of win-loss probabilities estimated by the BT model.}
 \item{logLik}{the model fit.}
}
\description{
\code{bradleyTerry} Computes the MLE for the BT model using an MM algorithm
}
\details{
In order to meet Bradley-Terry assumption, each ID in \code{conf.mat} should have at least one win AND one loss.
\code{bradleyTerry} will return an error if no more than one win or loss was found.
 
 @references 
   Shev, A., Hsieh, F., Beisner, B., & McCowan, B. (2012). Using Markov chain Monte Carlo (MCMC) to visualize and test the linearity assumption of the Bradley-Terry class of models. Animal behaviour, 84(6), 1523-1531.
   
   Shev, A., Fujii, K., Hsieh, F., & McCowan, B. (2014). Systemic Testing on Bradley-Terry Model against Nonlinear Ranking Hierarchy. PloS one, 9(12), e115367.
}
\examples{
# create an edgelist
edgelist1 <- data.frame(col1 = sample(letters[1:15], 200, replace = TRUE),
                        col2 = sample(letters[1:15], 200, replace = TRUE),
                       stringsAsFactors = FALSE)
edgelist1 <- edgelist1[-which(edgelist1$col1 == edgelist1$col2), ]
# convert an edgelist to conflict matrix
confmatrix_bt <- as.conflictmat(edgelist1)
# Computes the MLE for the BT model
bt <- bradleyTerry(confmatrix_bt)
}

