% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{rdist}
\alias{rdist}
\title{Generate a collection of permutations at a given distance}
\usage{
rdist(n, perm.length, dist.value, dist.name = "kendall")
}
\arguments{
\item{n}{number of permutations in the sample}

\item{perm.length}{number of items in the permutations}

\item{dist.value}{distance value}

\item{dist.name}{distance name. One of: kendall (default), cayley, hamming, ulam}
}
\value{
A sample of permutations at the given distance
}
\description{
Given a number of permutations, the number of items in the permutations,
a distance value and a distance name, generate a sample of permutations with 
the specified length at the given distance.
Can be used to generate derangements and permutations of a given number of cycles
}
\examples{
rdist(1, 4, 2 ) 
rdist(1, 4, 2, "ulam")
len <-  3
rdist(n = 1, perm.length = len, dist.value = len, "h") #derangement
cycles <- 2
rdist(n = 1, perm.length = len, dist.value = len - cycles, "c") #permutation with 2 cycles
}
