% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_modification.R
\name{obtain_mod_Maxquant}
\alias{obtain_mod_Maxquant}
\title{Obtain modification information from Peptide data generated by Maxquant}
\usage{
obtain_mod_Maxquant(
  data,
  column,
  PTM_table = NULL,
  PTM_annotation = FALSE,
  PTM_mass_column
)
}
\arguments{
\item{data}{A data.table with a column containing modified peptide sequences.}

\item{column}{The name of the column containing the modified peptide sequences.}

\item{PTM_table}{A data.table with columns 'PTM_mass' and 'PTM_type' containing PTM annotation information.}

\item{PTM_annotation}{A logical value indicating whether to include PTM annotation information in the result.}

\item{PTM_mass_column}{The name of the column containing the PTM mass information}
}
\value{
A data.table with 'PTM_position', 'PTM_type', 'reps', and other columns.
}
\description{
This function takes Maxquant output containing a column with modified peptide sequences
including PTM information and converts it into a new dataframe with the desired format of peptide
sequences and associated PTM information.
}
\examples{
library(data.table)
data <- data.table(
  'Modified sequence' = c(
    "_GLGPSPAGDGPS(Phospho (STY))GSGK_",
    "_HSSYPAGTEDDEGM(Oxidation (M))GEEPSPFR_",
    "_HSSYPAGTEDDEGM(Oxidation (M))GEEPS(Phospho (STY))PFR_"
  ),
  Condition = c("A", "B", "B")
)
PTM_table <- data.table(
  PTM_mass = c('Phospho (STY)', 'Oxidation (M)'),
  PTM_type = c("Phos", "Ox")
)
converted_data <- obtain_mod_Maxquant(
  data,
  'Modified sequence',
  PTM_table,
  PTM_annotation = TRUE,
  PTM_mass_column = "PTM_mass"
)

}
