% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSummarised.R
\name{plotCohortOverlap}
\alias{plotCohortOverlap}
\title{Plot the result of summariseCohortOverlap.}
\usage{
plotCohortOverlap(
  result,
  facetBy = "variable_name",
  overlapLabel = "{cohort_name_reference}; {cohort_name_comparator}",
  uniqueCombinations = TRUE
)
}
\arguments{
\item{result}{A summariseCohortOverlap result.}

\item{facetBy}{Names of columns in the result table for faceting the
ggplot object.}

\item{overlapLabel}{A glue expression to identify each plotted cohort
overlap.}

\item{uniqueCombinations}{If TRUE, only unique combinations of reference and
comparator plots will be plotted.}
}
\value{
A ggplot.
}
\description{
`r lifecycle::badge("experimental")`
}
\examples{
\donttest{
library(PatientProfiles)
cdm <- PatientProfiles::mockPatientProfiles()
overlap <- summariseCohortOverlap(cdm$cohort2)
plotCohortOverlap(overlap)
}

}
