% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseResult.R
\name{summariseResult}
\alias{summariseResult}
\title{Summarise the characteristics of different individuals}
\usage{
summariseResult(
  table,
  group = list(),
  includeOverallGroup = FALSE,
  strata = list(),
  includeOverallStrata = TRUE,
  variables = list(numericVariables = detectVariables(table, "numeric"), dateVariables =
    detectVariables(table, "date"), binaryVariables = detectVariables(table, "binary"),
    categoricalVariables = detectVariables(table, "categorical")),
  functions = list(numericVariables = c("median", "min", "q25", "q75", "max"),
    dateVariables = c("median", "min", "q25", "q75", "max"), binaryVariables = c("count",
    "percentage"), categoricalVariables = c("count", "percentage")),
  minCellCount = 5
)
}
\arguments{
\item{table}{Table with different records}

\item{group}{List of groups to be considered.}

\item{includeOverallGroup}{TRUE or FALSE. If TRUE, results for an overall
group will be reported when a list of groups has been specified.}

\item{strata}{List of the stratifications within each group to be considered.}

\item{includeOverallStrata}{TRUE or FALSE. If TRUE, results for an overall
strata will be reported when a list of strata has been specified.}

\item{variables}{List of the different groups of variables, by default they
are automatically classified.}

\item{functions}{List of functions to be applied to each one of the group of
variables.}

\item{minCellCount}{Minimum count of records to report results.}
}
\value{
Table that summarises the characteristics of the individual.
}
\description{
Summarise the characteristics of different individuals
}
\examples{
\donttest{
library(PatientProfiles)
library(dplyr)

cdm <- mockPatientProfiles()
x <- cdm$cohort1 \%>\%
  addDemographics(cdm) \%>\%
  collect()
result <- summariseResult(x)
}

}
