% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{plotNetBenefit}
\alias{plotNetBenefit}
\title{Plot the net benefit}
\usage{
plotNetBenefit(
  plpResult,
  typeColumn = "evaluation",
  saveLocation = NULL,
  fileName = "netBenefit.png",
  evalType = NULL,
  ylim = NULL,
  xlim = NULL
)
}
\arguments{
\item{plpResult}{A plp result object as generated using the \code{\link{runPlp}} function.}

\item{typeColumn}{The name of the column specifying the evaluation type}

\item{saveLocation}{Directory to save plot (if NULL plot is not saved)}

\item{fileName}{Name of the file to save to plot, for example 'plot.png'. See the function \code{ggsave} in the ggplot2 package for supported file formats.}

\item{evalType}{Which evaluation type to plot for. For example \code{Test}, \code{Train}. If NULL everything is plotted}

\item{ylim}{The y limits for the plot, if NULL the limits are calculated from the data}

\item{xlim}{The x limits for the plot, if NULL the limits are calculated from the data}
}
\value{
A list of ggplot objects or a single ggplot object if only one evaluation type is plotted
}
\description{
Plot the net benefit
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n=1000)
saveLoc <- file.path(tempdir(), "plotNetBenefit")
results <- runPlp(plpData, outcomeId = 3, saveDirectory = saveLoc)
plotNetBenefit(results)
# clean up
unlink(saveLoc, recursive = TRUE)
}
\dontshow{\}) # examplesIf}
}
