% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceDecay.R
\name{expDecay}
\alias{expDecay}
\title{Exponential decay function.}
\usage{
expDecay(x, signal, decay = 0.999, ...)
}
\arguments{
\item{x}{A numeric vector of distances (in [0,1]).}

\item{signal}{A single numeric value representing a signal.}

\item{decay}{The rate (in [0,1]) at which the signal decays.
This term indicates how much the \code{signal} decreases at a certain
distance in \code{x}. At the distance defined by the \code{pdist} term
(see \code{\link{circularProjection}}), the signal's value will
correspond to the initial signal multiplied by \code{1 - decay}.}

\item{...}{Not used; argument implemented for call compatibility with
the \code{\link{weibullDecay}} function.}
}
\value{
A numeric vector.
}
\description{
The \code{expDecay} function is used by PathwaySpace's methods
for signal convolution and projection.
}
\examples{
x <- c(1:100) / 100
y <- expDecay(x, 1)
plot(x, y)

}
\seealso{
\code{\link{weibullDecay}}, \code{\link{linearDecay}}
}
\author{
Vinicius Chagas, Victor Apolonio, and
Mauro Castro (\email{mauro.castro@ufpr.br})
}
