% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_downloadDaily.R
\name{monitor_downloadDaily}
\alias{monitor_downloadDaily}
\title{Download recent PM2.5 monitoring data}
\usage{
monitor_downloadDaily(
  parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring/latest/RData/",
  dataDir = "~/Data/monitoring/RData",
  ...
)
}
\arguments{
\item{parameter}{Parameter of interest.}

\item{baseUrl}{Base URL for data files.}

\item{dataDir}{Local directory in which to save the data file.}

\item{...}{Additional arguments passed to \code{download.file}.}
}
\description{
Downloads 'daily' data files into \code{dataDir} for later use.
Downloaded versions of PWFSL monitoring .RData files allow users to work with
the package without access to the internet. Once data are downloaded to
\code{dataDir}, any of the data loading functions can be called with the
\code{dataDir} argument to replace internet downloads with local file access.

The recommended directory for PWFSL monitoring data is
\code{"~/data/monitoring/RData"}.

For the most recent data, use \code{monitor_downloadLatest()}.

For data extended more than 45 days into the past, use \code{monitor_downloadAnnual()}.

Currently supported parameters include the following:
\enumerate{
\item{PM2.5}
}

Avaialble RData files can be seen at:
\href{https://haze.airfire.org/monitoring/latest/RData/}{https://haze.airfire.org/monitoring/latest/RData/}
}
\examples{
\donttest{
library(PWFSLSmoke)

monitor_loadLatest() \%>\%
  monitor_subset(stateCodes=CONUS) \%>\%
  monitor_map()
}
}
\seealso{
\code{\link{monitor_loadDaily}}
}
\keyword{AIRSIS}
\keyword{AirNow}
\keyword{WRCC}
