% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMarker.R
\name{addMarker}
\alias{addMarker}
\title{Add Icons to a Map or RgoogleMap Plot}
\usage{
addMarker(longitude, latitude, color = "red", map = NULL, expansion = 1,
  ...)
}
\arguments{
\item{longitude}{vector of longitudes}

\item{latitude}{vector of latitudes}

\item{color}{marker color: 'red', 'green', 'yellow', 'orange', or 'blue'. Also includes AQI 
category colors, specified 'AQI[number]' eg. 'AQI1'}

\item{map}{optional RgoogleMaps map object or Raster* object}

\item{expansion}{icon expansion factor. Ignored if width and height are specified.}

\item{...}{arguments passed on to \code{rasterImage}}
}
\description{
Adds a marker to a plot or \code{map} -- an RgoogleMaps map object or Raster* object.
}
\examples{
\dontrun{
ca <- airnow_load(20160801, 20160831, stateCodes='ca')
# Google map
map <- monitorGoogleMap(ca)
addMarker(ca$meta$longitude, ca$meta$latitude, map=map)
# line map
monitorMap(ca)
addMarker(ca$meta$longitude, ca$meta$latitude, color = "blue", expansion = 1)
}
}
\keyword{plotting}
