% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitorPlot_timeseries.R
\name{monitorPlot_timeseries}
\alias{monitorPlot_timeseries}
\title{Create Timeseries Plot}
\usage{
monitorPlot_timeseries(ws_monitor, monitorID = NULL, tlim = NULL,
  localTime = TRUE, style = NULL, shadedNight = FALSE, add = FALSE,
  gridPos = "", gridCol = "black", gridLwd = 1, gridLty = "solid",
  dayLwd = 0, hourLwd = 0, hourInterval = 6, ...)
}
\arguments{
\item{ws_monitor}{emph{ws_monitor} object}

\item{monitorID}{monitor ID for one or more monitor in the ws_monitor object}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH])}

\item{localTime}{logical specifying whether \code{tlim} is in local time or UTC}

\item{style}{custom styling, one of \code{'aqiDots'}}

\item{shadedNight}{add nighttime shading}

\item{add}{logical specifying whether to add to the current plot}

\item{gridPos}{position of grid lines either 'over', 'under' ('' for no grid lines)}

\item{gridCol}{grid line color}

\item{gridLwd}{grid line width}

\item{gridLty}{grid line type}

\item{dayLwd}{day marker line width}

\item{hourLwd}{hour marker line width}

\item{hourInterval}{interval for grid (max=12)}

\item{...}{additional arguments to be passed to \code{points()}}
}
\description{
Creates a time series plot of PM2.5 data from a emph{ws_monitor} object (see note below). Optional arguments
color code by AQI index, add shading to indicate nighttime, and adjust the time display (local vs. UTC).

When a named \code{style} is used, some graphical parameters will be overridden. Available styles include:

\itemize{
\item{\code{aqiDots}}{-- hourly values are individually colored by 24-hr AQI levels}
\item{\code{gnats}}{-- semi-transparent dots like a cloud of gnats}
}
}
\note{
Remember that a emph{ws_monitor} object can contain data from more than one monitor, and thus, this function may produce
a time series of data from multiple monitors. To plot a time series of an individual monitor's data, specify a single \code{monitorID}.
}
\examples{
N_M <- Northwest_Megafires
# monitorLeaflet(N_M) # to identify Spokane monitorIDs
Spokane <- monitor_subsetBy(N_M, stringr::str_detect(N_M$meta$monitorID,'^53063'))
monitorPlot_timeseries(Spokane, style='gnats')
title('Spokane PM2.5 values, 2015')
monitorPlot_timeseries(Spokane, tlim=c(20150801,20150831), style='aqiDots', pch=16)
addAQILegend()
title('Spokane PM2.5 values, August 2015')
monitorPlot_timeseries(Spokane, tlim=c(20150821,20150828), shadedNight=TRUE, style='gnats')
abline(h=AQI$breaks_24, col=AQI$colors, lwd=2)
addAQILegend()
title('Spokane PM2.5 values, August 2015')
}
\keyword{ws_monitor}

