% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elovichLM.r
\name{elovich.LM}
\alias{elovich.LM}
\title{Elovich Isotherm Linear Analysis}
\usage{
elovich.LM(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the linear regression, parameters for Elovich isotherm, and model
error analysis
}
\description{
Elovich isotherm model is based on kinetic principle which
assumes that the adsorption sites would exponentially increase with chemical
reactions responsible for adsorption. It is suited for describing the behavior
of adsorption concurring with the nature of chemisorption.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
elovich.LM(Ce,Qe)
}
\references{
Zeldowitsch, J. (1934). "über Den Mechanismus der Katalytischen
Oxidation Von CO a MnO2," URSS, Acta Physiochim, Vol. 1, No. 2, 1934, pp. 364-449.

Foo, K. Y., &amp; Hameed, B. H. (2009, September 13).
<doi:10.1016/j.cej.2009.09.013> Insights into the modeling of adsorption isotherm
systems. Chemical Engineering Journal.
}
\author{
Jemimah Christine L. Mesias

Chester C. Deocaris
}
