% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSpower.R
\name{PSpower}
\alias{PSpower}
\title{Calculate sample size needed to achieve a prespecified power}
\usage{
PSpower(
  tau,
  sig.level,
  power = NULL,
  r,
  phi,
  E1,
  E0,
  S1,
  S0,
  R1,
  R0,
  sample.size = NULL,
  test = "two-sided",
  estimand = "ATE"
)
}
\arguments{
\item{tau}{the estimated treatment effect $E[Y(1) - Y(0)]$}

\item{sig.level}{the significance level}

\item{power}{the power to achieve; if left NULL and sample.size is not NULL, will return the corresponding power given sample.size}

\item{r}{the proportion of treated units}

\item{phi}{the overlap coefficients}

\item{E1, E0, S1, S0, R1, R0}{the summary quantities}

\item{sample.size}{sample size to calculate power; ignored when power is not NULL}

\item{test}{whether one-sided or two-sided test is considered}

\item{estimand}{the estimand (ATE, ATT, ATC or ATO), or a customized tilting function}
}
\value{
an object with the calculated sample size
}
\description{
Calculate sample size needed to achieve a prespecified power
}
\examples{
PSpower(1, 0.05, 0.956, 0.5, 0.99, -1.74, -2.74, 19.86, 20.12, 0.14, 0.14)
}
