% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnadc_design.R
\name{pnadc_design}
\alias{pnadc_design}
\title{Create pnadc survey object utilizing its sampling design for analysis with survey package}
\usage{
pnadc_design(data_pnadc)
}
\arguments{
\item{data_pnadc}{A tibble of PNADc data read with \code{read_pnadc} function.}
}
\value{
An object of class \code{survey.design} with the data from PNADc survey and its sample design.
}
\description{
Create pnadc survey object utilizing its sampling design for analysis with survey package
}
\examples{

#Using data read from disk
input_path <- pnadc_example("input_example.txt")
data_path <- pnadc_example("exampledata.txt")
pnadc.df <- read_pnadc(data_path, input_path, vars="VD4002")
dictionary.path <- pnadc_example("dictionaryexample.xls")
pnadc.df <- pnadc_labeller(pnadc.df,dictionary.path)
\dontrun{
pnadc.svy <- pnadc_design(pnadc.df)
#Calculating unemployment rate
survey::svymean(~VD4002, pnadc.svy, na.rm=TRUE)}

#Downloading data
\dontrun{
pnadc.df2<- get_pnadc(2,2017,vars="VD4002")
pnadc.df2 <- pnadc_labeller(pnadc.df2,dictionary.path)
pnadc.svy2 <- pnadc_design(pnadc.df2)
#Calculating unemployment rate
survey::svymean(~VD4002, pnadc.svy2, na.rm=TRUE)}
}
