% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalScoresTest.R
\name{normalScoresTest}
\alias{normalScoresTest}
\alias{normalScoresTest.default}
\alias{normalScoresTest.formula}
\title{Lu-Smith Normal Scores Test}
\usage{
normalScoresTest(x, ...)

\method{normalScoresTest}{default}(x, g, ...)

\method{normalScoresTest}{formula}(formula, data, subset, na.action, ...)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated quantile of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{parameter}{the parameters of the test statistic, if any.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs the Lu-Smith normal score test
}
\details{
For one-factorial designs with non-normally distributed
residuals the Lu-Smith normal score test can be performed to test
the H\eqn{_0: F_1(x) = F_2(x) = \ldots = F_k(x)} against
the H\eqn{_\mathrm{A}: F_i (x) \ne F_j(x) ~ (i \ne j)} with at least
one strict inequality. This function is basically a wrapper function to
\code{\link[SuppDists]{pNormScore}} of the package \pkg{SuppDists}.
}
\examples{
normalScoresTest(count ~ spray, data = InsectSprays)
}
\references{
Lu, H., Smith, P. (1979) Distribution of normal scores statistic
for nonparametric one-way analysis of variance.
\emph{Journal of the American Statistical Association} \bold{74}, 715--722.
}
\seealso{
\code{\link{vanWaerdenTest}}, \code{\link{kruskalTest}},
\code{\link[SuppDists]{pNormScore}}
}
\keyword{htest}
\keyword{nonparametric}
