\name{ARTP.GE}
\alias{ARTP.GE}
\title{Gene and pathway p-values using ARTP method}
\usage{
  ARTP.GE(data.gene.pathway, list.gene.snp, p.snp.permut,
    p.snp.obs, inspect.snp.n = 1, inspect.snp.percent = 0,
    inspect.gene.n = 10, inspect.gene.percent = 0.05,
    temp.dir = "TEMP/", nperm)
}
\arguments{
  \item{data.gene.pathway}{Data frame (Gene X Pathways) of
  0 and 1 values. The rownames (gene name considered) and
  the colnames (names of the studied pathways) have to be
  specified. The value 1 indicates that a gene is included
  in the corresponding pathway.}

  \item{list.gene.snp}{List containing for each gene the
  corresponding SNP ids. This list could be generated by
  \code{data.to.list.gene.snp} function.}

  \item{p.snp.permut}{the output matrix from
  \code{\link{permutation.snp}} or a file with the SNP ids
  and p-values (see details).}

  \item{p.snp.obs}{The output data frame from
  \code{\link{compute.p.snp.obs}} or a file with the SNP
  ids and p-values (see details).}

  \item{inspect.snp.n}{The number of candidate truncation
  points to inspect the top SNPs in a gene. The default is
  1.}

  \item{inspect.snp.percent}{A value x between 0 and 1 such
  that a truncation point will be defined at every x
  percent of the top SNPs. The default is 0 so that the
  truncation points will be \code{1:inspect.snp.n}}

  \item{inspect.gene.n}{The number of candidate truncation
  points to inspect the top genes in the pathway. The
  default is 10.}

  \item{inspect.gene.percent}{A value x between 0 and 1
  such that a truncation point will be defined at every x
  percent of the top genes. The default is 0.05.}

  \item{temp.dir}{A folder to keep temporary files that
  will be created.}

  \item{nperm}{Number of permutation used.}
}
\value{
  The returned value is a list with names "res.gene.list"
  and "res.pathway". \code{res.gene.list} is a list with
  length equals to the number of investigated pathways.
  Each element of the list is a data frame containing the
  gene name, number of SNPs belonging to the gene that were
  included in the analysis, and the ARTP p-value for the
  gene. \code{res.pathway} contains the ARTP p-values for
  all the pathway analysed. The results contained in
  \code{res.pathway} are saved in a file named
  "ARTP-GEI.RData". The data frame containing all the gene
  analysed, the number of SNPs belonging to each gene and
  the ARTP p-value are saved in a file named
  "ARTP-GENE.RData".
}
\description{
  Calculate gene- and pathway-environment interaction
  p-values using the Adaptive Rank Truncated Product
  method. This function uses mainly the function
  \code{ARTP_pathway} developped by Kai Yu (R package
  ARTP).
}
\details{
  If the p-values are not computed using
  \code{\link{permutation.snp}}, and
  \code{\link{compute.p.snp.obs}} then the format for
  p.snp.obs and p.snp.permut should be as follows.  Both
  files must be uncompressed, comma seperated files with
  the first row as the SNP ids in the same order.  Row 2 of
  obs.file has the observed p-values, and starting from row
  2 in perm.file are the permuted p-values. A random seed
  should be set before calling \code{ARTP.GE.R} in order to
  reproduce results. The randomness is due to the ranking
  of p-values, where ties are broken randomly.
}
\examples{
data(data.pathway)
data(list.gene.snp)
\dontrun{
data(data.pige)

###First example: compute observed p-value (orignal data) and permuted p-value
res <-data.to.PIGE(data=data.pige,data.pathway=data.pathway,
list.gene.snp=list.gene.snp,choice.pathway=c(1,2))
formul <- formula(y~factor(cov1)+factor(cov2)+factor(cov3)+factor(cov4)
+var_int)
p.snp.obs.ex <-  compute.p.snp.obs(data=data.pige,model=formul,
indice.snp=res$snp.selected,var.inter="var_int",class.inter=NULL)
p.snp.permut.ex <-  permutation.snp(model=formul,data=data.pige,
indice.snp=res$snp.selected,var.inter="var_int",class.inter=NULL,
nbcpu=3,Npermut=9,file.out="res-permut")
set.seed(10)
result.1 <- ARTP.GE(data.gene.pathway=data.pathway,
list.gene.snp=list.gene.snp,p.snp.permut=p.snp.permut.ex,
p.snp.obs=p.snp.obs.ex,inspect.snp.n=5,inspect.snp.percent=0.05
,inspect.gene.n=10,inspect.gene.percent=0.05,temp.dir="TEMP/"
,nperm=9)
result.1

##Second example: observed and permuted p-values have already been computed
path.data <- paste(system.file("sampleData", package="PIGE"),"/",sep="")
res.permut <- read.table(file=paste(path.data,"res-permut.txt",sep="")
,header=TRUE,sep=" ")
res.obs   <- read.table(file=paste(path.data,"res-obs.txt",sep="")
,header=TRUE,sep=" ")
result.2 <- ARTP.GE(data.gene.pathway=data.pathway,
list.gene.snp=list.gene.snp, p.snp.permut=res.permut,
p.snp.obs=res.obs,inspect.snp.n=5,inspect.snp.percent=0.05,
inspect.gene.n=10,inspect.gene.percent=0.05,temp.dir="TEMP/",nperm=90)
result.2

##Third example: Survival data
##observed and permuted p-values have already been computed

data(data.surv)
data(data.pathway.surv)
data(list.gene.snp.surv)
path.data <- paste(system.file("sampleData", package="PIGE"),"/",sep="")
res.permut <- read.table(file=paste(path.data,"res-permut-surv.txt",sep="")
,header=TRUE,sep=" ")
res.obs   <- read.table(file=paste(path.data,"res-obs-surv.txt",sep="")
,header=TRUE,sep=" ")
result.3 <- ARTP.GE(data.gene.pathway=data.pathway.surv,
list.gene.snp=list.gene.snp.surv, p.snp.permut=res.permut,
p.snp.obs=res.obs,inspect.snp.n=5,inspect.snp.percent=0.05,
inspect.gene.n=10,inspect.gene.percent=0.05,temp.dir="TEMP/",nperm=90)
result.3
}}
\author{
  Benoit Liquet
  \email{benoit.liquet@isped.u-bordeaux2.fr}\cr Therese
  Truong \email{therese.truong@inserm.fr}
}
\references{
  Yu K, Li Q, Berger AW, Pfeiffer R, Rosenberg P, Caporaso
  N, Kraft P, Chatterjee N (2009). Pathway analysis by
  adaptive combination of P-values. Genet Epidemiol
  33:700-709.
}

