% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PowANOVADat.R
\name{PowANOVADat}
\alias{PowANOVADat}
\title{A function to obtain a power table with the combination of
various number of PDX lines and number of individuals per PDX lines per treatment based on a preliminary dataset}
\usage{
PowANOVADat(
  data = NULL,
  formula = NULL,
  random = NULL,
  n = NULL,
  m = NULL,
  sim = 100,
  two.sided = TRUE,
  alpha = 0.05,
  fixed.effect = FALSE,
  ncores = NULL
)
}
\arguments{
\item{data}{data.frame in which to interpret the variables named in the formula.}

\item{formula}{a two-sided linear formula object describing the fixed-effects part of the model,
with the response on the left of a ~ operator and the terms, separated by + operators, on the right.}

\item{random}{an one-sided formula of the form \code{~ x1 + ... + xn | ID}.}

\item{n}{an integer number to specify the number of PDX lines.}

\item{m}{an integer number to specify the number of individuals per PDX line per treatment.}

\item{sim}{Number of Monte Carlo samples to be generated. Default is 1000.}

\item{two.sided}{a logical value to indicate if a two-sided hypothesis testing is conducted. Default is TRUE.}

\item{alpha}{significance level. Default is 0.05.}

\item{fixed.effect}{logical value to indicate if a fixed effects only model is fitted. Default is FALSE.}

\item{ncores}{number of cores for parallel computation.}
}
\value{
Object of \code{PowANOVADat} with elements
\item{beta}{the estimated treatment effect from the pilot data.}
\item{tau2}{the estimated inter-PDX variance from the pilot data.}
\item{sigma2}{the estimated random error variance from the pilot data.}
\item{PowTab}{the estimates of statistical power across \code{n} and \code{m}.}
}
\description{
A function to obtain a power table with the combination of
various number of PDX lines and number of individuals per PDX lines per treatment based on a preliminary dataset
}
\examples{
\donttest{
require(PDXpower)
data(animals1)
PowTab <- PowANOVADat(data = animals1, formula = log(Y) ~ Tx, random = ~ 1|ID,
n = 3, m = 2, ncores = 1)
PowTab
plotpower(PowTab[[4]], ylim = c(0, 1))
}
}
