% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMParam.R
\name{PCMParamLocateInShortVector}
\alias{PCMParamLocateInShortVector}
\title{Locate a named parameter in the short vector representation of a model}
\usage{
PCMParamLocateInShortVector(o, accessExpr)
}
\arguments{
\item{o}{a PCM model object.}

\item{accessExpr}{a character string used to access the parameter, e.g.
\code{"$Theta[,,1]"} or \code{"[['Theta']][,,1]"}.}
}
\value{
an integer vector of length \code{PCMParamCount(o)} with NAs
everywhere except at the coordinates corresponding to the parameter in
question.
}
\description{
Locate a named parameter in the short vector representation of a model
}
\examples{

model <- PCM(PCMDefaultModelTypes()["C"], k = 3, regimes = c("a", "b"))
# The parameter H is a diagonal 3x3 matrix. If this matrix is considered as
# a vector the indices of its diagonal elements are 1, 5 and 9. These indices
# are indicated as the non-NA entries in the returned vector.

PCMParamLocateInShortVector(model, "$H[,,1]")
PCMParamLocateInShortVector(model, "$H[,,'a']")
PCMParamLocateInShortVector(model, "$H[,,'b']")
}
