% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchSeascape.R
\name{matchSeascape}
\alias{matchSeascape}
\title{Match Seascape Class to Data}
\usage{
matchSeascape(x, type = c("monthly", "8day"), progress = TRUE)
}
\arguments{
\item{x}{a dataframe with columns \code{UTC}, \code{Latitude} and
\code{Longitude} to add environmental data to}

\item{type}{the type of seascape data to download, one of
"monthly" or "8day"}

\item{progress}{logical flag whether or not to show download progress}
}
\value{
the same dataframe as \code{x}, but with new columns
\code{seascapeClass} and \code{seascapeProb} representing the
"CLASS" and "P" variables from the dataset
}
\description{
Downloads and matches relevant Seascape class
data from the ERDDAP (Environmental Research Division's
Data Access Program) server at
\url{https://cwcgom.aoml.noaa.gov/erddap/index.html}. More
information on theclasses can be found on the help page for
the seascapeR package
\url{https://marinebon.github.io/seascapeR/index.html}.
}
\details{
This function is just a wrapper around \link[PAMmisc]{matchEnvData}
pointing to the specific base URL and dataset ID relevant for seascape
data
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
