% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addNote.R
\name{addNote}
\alias{addNote}
\alias{getNotes}
\title{addNote}
\usage{
addNote(x, to = c("study", "event"), evNum = 1, label = NULL, note)

getNotes(x)
}
\arguments{
\item{x}{An \linkS4class{AcousticStudy} or \linkS4class{AcousticEvent} object}

\item{to}{One of "study" or "event", which object to add the note to}

\item{evNum}{If \code{x} is an AcousticStudy and \code{to} is "event", the
number or name of the event(s) to add notes to (can be a vector of numbers
or names to add the same note to multiple events)}

\item{label}{(optional) a short header or label for the note. Recommended to
set this as a sumamry of the more detailed note}

\item{note}{the full note message}
}
\value{
For \code{addNote}, the same data as \code{x}, with notes added.
  For \code{getNotes}, a list of all notes present in \code{x}
}
\description{
Adds a note to an AcousticEvent or AcousticStudy. Notes can either
  be accessed with the "getNotes" function, or up to 6 notes will be printed
  when the object is printed
}
\examples{

data(exStudy)
exStudy <- addNote(exStudy, to='study', label='Note1',
                   note='My first note for this study')
exStudy <- addNote(exStudy, to='event', evNum=1:2, label='Note2',
                   note='A note for the first two events')
exStudy <- addNote(exStudy[[1]], to='event', label='Note3',
                   note='A second note for the first event')
exStudy

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
