# function to summarize estimation results
summary.PAFit_result <- function(object,...){
  if (length(object$oneshot) > 0) {
    if (object$oneshot == TRUE)  
      cat("Containing the result of the PAFit_oneshot method. \n")
  } else {
    cat("Estimation results by the PAFit method. \n");
  
     if (object$only_PA == TRUE) {
        cat("Mode: Only the attachment function was estimated. \n")     
    } else if (object$only_f == TRUE) {
        cat("Mode: Only node fitnesses were estimated. \n")
    }
    else {
        cat("Mode: Both the attachment function and node fitness were estimated. \n")
    }
  }
    #cat("Form of the PA function:",object$mode_f,"\n");
  
    if (object$only_f == FALSE) {
      if (length(object$auto_lambda) > 0) {  
        if (object$auto_lambda == TRUE) {
            cat("Selected r parameter:", object$ratio,"\n");  
        } else cat("Lambda used:", object$lambda,"\n");
      }
    }
    if (object$only_PA == FALSE)
        cat("Selected s parameter: ",object$shape,"\n", sep = "")
    cat("Estimated attachment exponent:",object$alpha,"\n");
    if (object$ci[1] == "N") {
      cat("No possible confidence interval for the estimated attachment exponent.\n");
    } else if (length(object$mode_f > 0))  {
       if (object$mode_f != "Log_linear") {
         cat("Attachment exponent ","\u00B1", " 2 s.d.", ": (", object$ci[1], ",", 
          object$ci[2],")\n",sep = "");
       }
    }
    else {
      cat("Attachment exponent ","\u00B1", " 2 s.d.", ": (", object$ci[1], ",", 
          object$ci[2],")\n",sep = "");  
    }
    if (length(object$oneshot)  == 0) {
    
        cat("-------------------------------------------\n")
        cat("Additional information: \n");
        cat("Number of bins:", object$g,"\n");
        cat("Number of iterations:",length(object$objective_value) - 1,"\n");
        cat("Stopping condition:", object$stop_cond,"\n");
    }
}