% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PACLasso.R
\name{lin.int}
\alias{lin.int}
\title{Initialize Linear Programming Fit (Equality Constraints)}
\usage{
lin.int(C.full, b)
}
\arguments{
\item{C.full}{complete constraint matrix C (with constraints of the form \code{C.full}*\code{beta}=\code{b})}

\item{b}{constraint vector b}
}
\value{
\code{beta} the initial beta vector of coefficients to use for the PaC algorithm
}
\description{
This function is called internally by \code{lars.c}
  to get the linear programming initial fit if the user requests
  implementation of the algorithm starting at the largest lambda
  value and proceeding backwards.
}
\examples{
random_data = generate.data(n = 500, p = 20, m = 10)
lin_start = lin.int(random_data$C.full, random_data$b)
lin_start
}
