% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_intens.R
\name{smooth_intens}
\alias{smooth_intens}
\alias{smooth_intens.formula}
\alias{smooth_intens.data.frame}
\alias{smooth_intens.default}
\title{Smooth spectral intensities}
\usage{
smooth_intens(x, ...)

\method{smooth_intens}{formula}(formula, data = NULL, ...)

\method{smooth_intens}{data.frame}(x, ...)

\method{smooth_intens}{default}(x, y, p = 3, n = 11, make_rel = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector containing the spectral wavenumbers; alternatively
a data frame containing spectral data as \code{"wavenumber"} and
\code{"intensity"} can be supplied.}

\item{formula}{an object of class '\code{\link[stats]{formula}}' of the form
\code{intensity ~ wavenumber}.}

\item{data}{a data frame containing the variables in \code{formula}.}

\item{y}{a numeric vector containing the spectral intensities.}

\item{p}{polynomial order for the filter}

\item{n}{number of data points in the window, filter length (must be odd).}

\item{make_rel}{logical; if \code{TRUE} spectra are automatically normalized
with \code{\link{make_rel}()}.}

\item{\ldots}{further arguments passed to \code{\link[signal]{sgolay}()}.}
}
\value{
\code{smooth_intens()} returns a data frame containing two columns named
\code{"wavenumber"} and \code{"intensity"}.
}
\description{
This smoother can enhance the signal to noise ratio of the data and uses a
Savitzky-Golay filter with a running window of data points and the polynomial
specified.
}
\details{
This is a wrapper around the filter function in the signal package to improve
integration with other Open Specy functions.
A typical good smooth can be achieved with 11 data point window and a 3rd or
4th order polynomial.
}
\examples{
data("raman_hdpe")

smooth_intens(raman_hdpe)

}
\references{
Savitzky A, Golay MJ (1964). “Smoothing and Differentiation of Data by
Simplified Least Squares Procedures.” \emph{Analytical Chemistry},
\strong{36}(8), 1627--1639.
}
\seealso{
\code{\link[signal]{sgolay}()}
}
\author{
Win Cowger, Zacharias Steinmetz
}
