% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repgrid-basicops.r
\name{ratings}
\alias{ratings}
\alias{ratings_df}
\alias{ratings<-}
\title{Extract ratings (wide or long format)}
\usage{
ratings(x, names = TRUE, trim = 10)

ratings_df(x, long = FALSE, names = TRUE, trim = NA)

ratings(x, i, j) <- value
}
\arguments{
\item{x}{A \code{repgrid} object.}

\item{names}{Extract row and columns names (constructs and elements).}

\item{trim}{The number of characters a row or column name is trimmed to
(default is \code{10}). If \code{NA} no trimming is done. Trimming simply
saves space when displaying the output.}

\item{long}{Return as long format? (default \code{FALSE})}

\item{i, j}{Row and column indices.}

\item{value}{Numeric replacement value(s).}
}
\value{
A \code{matrix}.#'
}
\description{
Extract ratings (wide or long format)
}
\examples{

## store Bell's dataset in x
x <- bell2010

## get ratings
ratings(x)


## replace ratings

ratings(x)[1, 1] <- 1
# noet that this is even simpler using the repgrid object directly
x[1, 1] <- 2

# replace several values

ratings(x)[1, 1:5] <- 1
x[1, 1:5] <- 2 # the same

ratings(x)[1:3, 5:6] <- matrix(5, 3, 2)
x[1:3, 5:6] <- matrix(5, 3, 2) # the same


## ratings as dataframe in wide or long format

ratings_df(x)
ratings_df(x, long = TRUE)

}
\seealso{
\verb{[<--method}
}
