% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpenRepGrid.ic.R
\docType{package}
\name{OpenRepGrid.ic}
\alias{OpenRepGrid.ic}
\title{\pkg{OpenRepGrid.ic} -  Interpretive Clustering for Repertory Grids}
\description{
The \pkg{OpenRepGrid.ic} package implements \emph{Interpretive Clustering (IC)} 
as outlined in \href{https://doi.org/10.1080/14780887.2020.1794088}{Burr, King, and Heckmann (2020)}. The authors describe
a variant of construct clustering which uses a procedure from graph theory
called \href{https://en.wikipedia.org/wiki/Clique_problem#Listing_all_maximal_cliques}{maximal cliques enumeration}.
Given a similarity measure, in our case the number of matching scores between
two constructs, a network graph of relatedness between constructs is
construed. A clique is a group of constructs which are all mutually related,
given some cut-off criterion for relatedness (e.g. 6 matching scores in a
grid with 7 elements). While the paper also describes an offline approach to identify
the construct cliques, this software automates the process. Under the hood, 
the package uses the \code{igraph} package for clique identification. 

The package also contains a shiny based UI you can start via the function 
\code{ic()}. Visit \url{http://ic.openrepgrid.org} for an online version. 
Below you find an example of how to process a repgrid in an Excel
file using code only.
}
\examples{
# The shiny package is just a small UI wrapper around the 
# the workhorse core functions. Here is how to call them.

library(tidyverse)
library(openxlsx)
library(igraph)
library(OpenRepGrid.ic)

file <- system.file("extdata", "sylvia.xlsx", package = "OpenRepGrid.ic")
file_out <- str_replace(file, ".xlsx$", " CLIQUES.xlsx") \%>\% basename

x <- read.xlsx(file)            # read grid
tests <- check_excel_input(x)   # check if input format is correct
l <- network_graph_images(x, min_clique_size = 3, 
                          show_edges = TRUE, 
                          min_matches = 6)    # produce images
file_tmp <- create_excel_output(file, l)      # create Excel file

# copy Excel to working dir (commented out to avoid file generation during testing)
#file.copy(file_tmp, file_out, overwrite = TRUE)  

# calculation results used in network_graph_images
# some of them are also contained in Excel file
s <- calculate_similarity(x)
s


}
\references{
Burr, V. King, N. & Heckmann, M. (2020) The qualitative analysis of repertory grid data: Interpretive Clustering, 
    Qualitative Research in Psychology, DOI: 10.1080/14780887.2020.1794088
}
\keyword{OpenRepGrid.ic}
\keyword{package}
