% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict.blrmfit}
\alias{posterior_predict.blrmfit}
\alias{posterior_predict}
\title{Posterior of predictive}
\usage{
\method{posterior_predict}{blrmfit}(object, newdata, draws, ...)
}
\arguments{
\item{object}{fitted model object}

\item{newdata}{optional data frame specifying for what to predict;
if missing, then the data of the input model \code{object} is
used}

\item{draws}{number of returned posterior draws; by default the
entire posterior is returned}

\item{...}{not used in this function}
}
\value{
Matrix of dimensions \code{draws} by \code{nrow(newdata)}
    where row correspond to a draw of the posterior and each
    column corresponds to a row in \code{newdata}. The columns are
    labelled with the \code{row.names} of \code{newdata}.
}
\description{
Simulation of the predictive distribution.
}
\details{
Simulates the posterior predictive of the model \code{object} for
the specified data set.
}
\section{Group and strata definitions}{


The groups and strata as defined when running the \code{blrm_exnex}
analysis cannot be changed at a later stage. As a result no
evaluations can be performed for groups which have not been present
in the data set used for running the analysis. However, it is
admissible to code the group (and/or stratum) column as a
\code{factor} which contains empty levels. These groups are thus
not contained in the fitting data set and they are assigned by
default to the first stratum. In addition priors must be setup for
these groups (and/or strata). These empty group (and/or strata)
levels are then allowed in subsequent evaluations. This enables the
evaluation of the hierarchical model in terms of representing a
prior for future groups.
}

\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1,
                            OncoBayes2.MC.save_warmup=FALSE)


example_model("single_agent", silent=TRUE)

post_pred  <- posterior_predict(blrmfit)
## turn DLT counts into DLT rates
post_pred_rate <- sweep(post_pred, 2, hist_SA$num_patients, "/")

library(bayesplot)
library(ggplot2)

## compare posterior predictive of the model for the response rates
## with observed data
with(hist_SA,
    ppc_intervals(num_toxicities / num_patients, post_pred_rate, x=drug_A, prob_outer=0.95)) +
    xlab("Dose [mg]")

## Recover user set sampling defaults
options(.user_mc_options)

}
