% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codata_combo2.R
\docType{data}
\name{codata_combo2}
\alias{codata_combo2}
\title{Dataset: historical and concurrent data on a two-way combination}
\format{
A data frame with 20 rows and 5 variables:
\describe{
  \item{group_id}{study}
  \item{drug_A}{dose of Drug A}
  \item{drug_B}{dose of Drug B}
  \item{num_patients}{number of patients}
  \item{num_toxicities}{number of DLTs}
  \item{cohort_time}{cohort number of patients}
}
}
\usage{
codata_combo2
}
\description{
One of two datasets from the application described in Neuenschwander et al
(2016). In the study \code{trial_AB}, the risk of DLT was studied as a function of
dose for two drugs, drug A and drug B. Historical information on the toxicity
profiles of these two drugs is available from single agent trials \code{trial_A}
and \code{trial_B}. Another study \code{IIT} was run concurrently to \code{trial_AB}, and
studies the same combination. A second dataset \code{hist_combo2} is
available from this example, which includes only the data from the single
agent studies, prior to the initiation of \code{trial_AB} and \code{IIT}.
}
\examples{
## Setting up dummy sampling for fast execution of example
## Please use 4 chains and 100x more warmup & iter in practice
.user_mc_options <- options(OncoBayes2.MC.warmup=10, OncoBayes2.MC.iter=20, OncoBayes2.MC.chains=1,
                            OncoBayes2.MC.save_warmup=FALSE)

dref <- c(6, 960)

num_comp <- 2 # two investigational drugs
num_inter <- 1 # one drug-drug interaction needs to be modeled
num_groups <- nlevels(codata_combo2$group_id) # no stratification needed
num_strata <- 1 # no stratification needed

blrmfit <- blrm_exnex(
  cbind(num_toxicities, num_patients - num_toxicities) ~
      1 + I(log(drug_A / dref[1])) |
      1 + I(log(drug_B / dref[2])) |
      0 + I(drug_A/dref[1] *drug_B/dref[2]) |
      group_id,
  data = codata_combo2,
  prior_EX_mu_mean_comp = matrix(
     c(logit(0.2), 0,  # hyper-mean of (intercept, log-slope) for drug A
       logit(0.2), 0), # hyper-mean of (intercept, log-slope) for drug B
       nrow = num_comp,
       ncol = 2,
       byrow = TRUE
      ),
  prior_EX_mu_sd_comp = matrix(
     c(2.0, 1,  # hyper-sd of mean mu for (intercept, log-slope) for drug A
       2.0, 1), # hyper-sd of mean mu for (intercept, log-slope) for drug B
       nrow = num_comp,
       ncol = 2,
       byrow = TRUE
      ),
  prior_EX_tau_mean_comp = matrix(
     c(log(0.25), log(0.125),
       log(0.25), log(0.125)),
       nrow = num_comp,
       ncol = 2,
       byrow = TRUE
      ),
  prior_EX_tau_sd_comp = matrix(
     c(log(4) / 1.96, log(4) / 1.96,
       log(4) / 1.96, log(4) / 1.96),
       nrow = num_comp,
       ncol = 2,
       byrow = TRUE
      ),
  prior_EX_mu_mean_inter = 0,
  prior_EX_mu_sd_inter = 1.121,
  prior_EX_tau_mean_inter = matrix(log(0.125), nrow = num_inter, ncol = num_strata),
  prior_EX_tau_sd_inter = matrix(log(4) / 1.96, nrow = num_inter, ncol = num_strata),
  prior_is_EXNEX_comp = rep(FALSE, num_comp),
  prior_is_EXNEX_inter = rep(FALSE, num_inter),
  prior_EX_prob_comp = matrix(1, nrow = num_groups, ncol = num_comp),
  prior_EX_prob_inter = matrix(1, nrow = num_groups, ncol = num_inter),
  prior_tau_dist = 1
 )
## Recover user set sampling defaults
options(.user_mc_options)

}
\references{
Neuenschwander, B., Roychoudhury, S., & Schmidli, H. 
 (2016). On the use of co-data in clinical trials. \emph{Statistics in 
 Biopharmaceutical Research}, 8(3), 345-354.
}
\keyword{datasets}
