% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{addMetaFeatures}
\alias{addMetaFeatures}
\title{Add meta-feature metadata}
\usage{
addMetaFeatures(study, metaFeatures, reset = FALSE)
}
\arguments{
\item{study}{An OmicNavigator study created with \code{\link{createStudy}}}

\item{metaFeatures}{The metadata variables that describe the meta-features in
the study. The input object is a list of data frames (one per model). The
first column of each data frame is used as the featureID, so it must
contain the same IDs as the corresponding features data frame
(\code{\link{addFeatures}}). To share a data frame across multiple models,
use the modelID "default". All columns will be coerced to character
strings.}

\item{reset}{Reset the data prior to adding the new data (default:
\code{FALSE}). The default is to add to or modify any previously added data
(if it exists). Setting \code{reset = TRUE} enables you to remove existing
data you no longer want to include in the study.}
}
\value{
Returns the original \code{onStudy} object passed to the argument
  \code{study}, but modified to include the newly added data
}
\description{
The meta-features table is useful anytime there are metadata variables that
cannot be mapped 1:1 to your features. For example, a peptide may be
associated with multiple proteins.
}
