/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.creator;

import java.util.Map;
import nu.xom.Node;
import org.andwellness.xml.datagenerator.creator.DataPointCreator;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.andwellness.xml.datagenerator.utility.ValueCreator;
import org.apache.log4j.Logger;

public class SingleChoiceDataPointCreator
extends DataPointCreator {
    private Logger _logger = Logger.getLogger(SingleChoiceDataPointCreator.class);

    @Override
    public DataPoint create(Node currentNode) {
        String displayType = currentNode.query("displayType").get(0).getValue();
        String nodeId = currentNode.query("id").get(0).getValue();
        DataPoint createdDataPoint = new DataPoint();
        createdDataPoint.setId(nodeId);
        createdDataPoint.setPromptType(DataPoint.PromptType.single_choice);
        createdDataPoint.setDisplayType(displayType);
        Node propertyNode = currentNode.query("properties").get(0);
        Map<String, String> nodeProperties = this.extractProperties(propertyNode);
        int numberKeys = nodeProperties.size();
        int chosenKeyNumber = ValueCreator.randomPositiveIntModulus(numberKeys);
        int chosenValue = Integer.parseInt((String)nodeProperties.keySet().toArray()[chosenKeyNumber]);
        createdDataPoint.setValue(new Integer(chosenValue));
        if (this._logger.isDebugEnabled()) {
            this._logger.debug("Creating a single choice data point with id " + nodeId + " value " + chosenValue);
        }
        return createdDataPoint;
    }
}

