% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsr_step.R
\name{opsr_step}
\alias{opsr_step}
\title{Step Function for OPSR Model Fits}
\usage{
opsr_step(object, pval, log = new.env(), .step = 1, ...)
}
\arguments{
\item{object}{an object of class \code{"opsr"}.}

\item{pval}{coefficients with p-values < \code{pval} are dropped.}

\item{log}{environment to keep track of changes to \code{object} (in particular
variables being eliminated). This could be useful in a function that
repeatedly calls \code{opsr_step} internally in order to keep track of the full
elimination history.}

\item{.step}{used to generate identifier in \code{log} environment.}

\item{...}{additional arguments passed to \code{\link{update}} (and hence \code{\link{opsr}}).}
}
\value{
An object of class \code{"opsr"}.
}
\description{
Excludes all coefficients with p-values below \code{pval} and fits again.
}
\examples{
sim_dat <- OPSR::opsr_simulate()
dat <- sim_dat$data
dat$xo3 <- runif(n = nrow(dat))
dat$xo4 <- factor(sample(c("level1", "leve2", "level3"), nrow(dat), replace = TRUE))
f <- ys | yo ~ xs1 + xs2 + log(xo3) | xo1 + xo2 + xo3 + xo4 | xo1 + xo2 + xo3 | xo1 + xo2
fit <- OPSR::opsr(f, dat, printLevel = 0)
fit_step <- opsr_step(fit, pval = 0.1)
texreg::screenreg(list(fit, fit_step))
}
