% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Octopus900.r
\name{opiInitialise_for_Octopus900}
\alias{opiInitialise_for_Octopus900}
\title{Implementation of opiInitialise for the Octopus900 machine.}
\arguments{
\item{serverPort}{port number on which server is listening for "Octopus900"}

\item{eyeSuiteSettingsLocation}{dir name containing EyeSuite settings for "Octopus900"}

\item{eye}{eye; "right" or "left" for "Octopus900", "Octopus600"}

\item{gazeFeed}{NA or a folder name for "Octopus900"}

\item{bigWheel}{FALSE (standard machine), TRUE for modified aperture wheel for "Octopus900"}

\item{pres_buzzer}{0 (no buzzer),1, 2, 3 (max volume) for "Octopus900"}

\item{resp_buzzer}{0 (no buzzer),1, 2, 3 (max volume) for "Octopus900"}

\item{zero_dB_is_10000_asb}{Is 0 dB 10000 apostilb (TRUE) or or 4000 (FALSE) for "Octopus900"}
}
\value{
A list containing \code{err} which is
\itemize{
\item NULL if successful
\item 1 if Octopus900 is already initialised by a previous call to \code{opiInitialize}
\item 2 if some error occurred that prevented initialisation.
}
}
\description{
This is for internal use only. Use \code{\link[=opiInitialise]{opiInitialise()}} with
these Arguments and you will get the Value back.
}
\details{
If the chosen OPI implementation is \code{Octopus900}, then you must specify
a directory and the eye to be tested.

\code{serverPort} is the TCP/IP port on which the server is listening (on
localhost).

\code{eyeSuiteSettingsLocation} is the folder name containing the EyeSuite
setting files, and should include the trailing slash.

\code{eye} must be either "left" or "right".

\code{gazeFeed} is the name of an existing folder into which the video frames
of eye tracker are recorded. Set to \code{NA} for no recording.

\code{bigWheel} is \code{FALSE} for a standard Octopus 900 machine. Some
research machines are fitted with an alternate aperture wheel that has 24
sizes, which are accessed with \code{bigWheel} is \code{TRUE}. The mapping
from size to 'hole on wheel' is hard coded; see code for details.

If \code{pres_buzzer} is greater than zero, a buzzer will sound with each
stimuli presented.

If \code{resp_buzzer} is greater than zero, a buzzer will sound with each
button press (response). The volume can be one of 0 (no buzzer), 1, 2, or 3
(max volume). If both buzzers are more than zero, the maximum of the two will
be used as the volume.

If \code{zero_dB_is_10000_asb} is \code{TRUE} then 0 dB is taken as 10000
apostilbs, otherwise 0 dB is taken as 4000 apostilbs.
}
\examples{
\dontrun{
  chooseOpi("Octopus900")
  res <- opiInitialize(serverPort = 50001,
                       eyeSuiteSettingsLocation = "C:/ProgramData/Haag-Streit/EyeSuite/",
                       eye = "", gazeFeed = "", bigWheel = FALSE,
                       pres_buzzer = 0, resp_buzzer = 0, zero_dB_is_10000_asb = TRUE)
  if (!is.null(res$err))
      stop("opiInitialize failed")
}
}
