% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MvtBurr.R
\name{MvtBurr}
\alias{MvtBurr}
\alias{dmvburr}
\alias{pmvburr}
\alias{qmvburr}
\alias{rmvburr}
\alias{smvburr}
\title{Multivariate Burr Distribution}
\usage{
dmvburr(x, parm1 = 1, parm2 = rep(1, k), parm3 = rep(1, k),
  log = FALSE)

pmvburr(q, parm1 = 1, parm2 = rep(1, k), parm3 = rep(1, k))

qmvburr(p, parm1 = 1, parm2 = rep(1, k), parm3 = rep(1, k),
  interval = c(0, 1e+08))

rmvburr(n, parm1 = 1, parm2 = rep(1, k), parm3 = rep(1, k))

smvburr(q, parm1 = 1, parm2 = rep(1, k), parm3 = rep(1, k))
}
\arguments{
\item{x}{vector or matrix of quantiles. If x is a matrix, each row vector constitutes a vector of quantiles for which the density f(x) is calculated (for \eqn{i}-th row \eqn{x_i}, \eqn{f(x_i)} is reported).}

\item{parm1}{a scalar parameter, see parameter \eqn{a} in \strong{Details}.}

\item{parm2}{a vector of parameters, see parameters \eqn{d_i} in \strong{Details}.}

\item{parm3}{a vector of parameters, see parameters \eqn{c_i} in \strong{Details}.}

\item{log}{logical; if TRUE, probability densities f are given as log(f).}

\item{q}{a vector of quantiles.}

\item{p}{a scalar value corresponding to probability.}

\item{interval}{a vector containing the end-points of the interval to be searched. Default value is set as \code{c(0, 1e8)}.}

\item{n}{number of observations.}

\item{k}{dimension of data or number of variates.}
}
\value{
\code{dmvburr} gives the numerical values of the probability density.

\code{pmvburr} gives the cumulative probability.

\code{qmvburr} gives the equicoordinate quantile.

\code{rmvburr} generates random numbers.

\code{smvburr} gives the value of survival function.
}
\description{
Calculation of density function, cumulative distribution function, equicoordinate quantile function and survival function, and random numbers generation for multivariate Burr distribution with a scalar parameter \code{parm1} and vectors of parameters \code{parm2} and \code{parm3}.
}
\details{
Multivariate Burr distribution (Johnson and Kotz, 1972) is a joint distribution of positive random variables \eqn{X_1, \cdots, X_k}. Its probability density is given as
\deqn{f(x_1, \cdots, x_k) = \frac{[ \prod_{i=1}^{k} c_i d_i] a(a+1) \cdots (a+k-1) [ \prod_{i=1}^{k} x_i^{c_i-1}]}{(1 + \sum_{i=1}^{k} d_i x_i^{c_i})^{a+k}},}
where \eqn{x_i >0, a,c_i,d_i>0, i=1,\cdots, k}.

Cumulative distribution function \eqn{F(x_1, \dots, x_k)} is obtained by the following formula related to survival function \eqn{\bar{F}(x_1, \dots, x_k)} (Joe, 1997)
\deqn{F(x_1, \dots, x_k) = 1 + \sum_{S \in \mathcal{S}} (-1)^{|S|} \bar{F}_S(x_j, j \in S),}
where the survival function is given by
\deqn{\bar{F}(x_1, \cdots, x_k) = \left( 1+\sum_{i=1}^{k} d_i x_i^{c_i} \right)^{-a}.}

Equicoordinate quantile is obtained by solving the following equation for \eqn{q} through the built-in one dimension root finding function \code{\link{uniroot}}:
\deqn{\int_{0}^{q} \cdots \int_{0}^{q} f(x_1, \cdots, x_k) dx_k \cdots dx_1 = p,}
where \eqn{p} is the given cumulative probability.

Random numbers \eqn{X_1, \cdots, X_k} from multivariate Burr distribution can be generated through transformation of multivariate Lomax random variables \eqn{Y_1, \cdots, Y_k} by letting \eqn{X_i=(\theta_i Y_i/d_i)^{1/c_i}, i = 1, \cdots, k}; see Nayak (1987).
}
\examples{
# Calculations for the multivariate Burr with parameters:
# a = 3, d1 = 1, d2 = 3, d3 = 5, c1 = 2, c2 = 4, c3 = 6
# Vector of quantiles: c(3, 2, 1)

dmvburr(x = c(3, 2, 1), parm1 = 3, parm2 = c(1, 3, 5), parm3 = c(2, 4, 6)) # Density

pmvburr(q = c(3, 2, 1), parm1 = 3, parm2 = c(1, 3, 5), parm3 = c(2, 4, 6)) # Cumulative Probability

# Equicoordinate quantile of cumulative probability 0.5
qmvburr(p = 0.5, parm1 = 3, parm2 = c(1, 3, 5), parm3 = c(2, 4, 6))

# Random numbers generation with sample size 100
rmvburr(n = 100, parm1 = 3, parm2 = c(1, 3, 5), parm3 = c(2, 4, 6))

smvburr(q = c(3, 2, 1), parm1 = 3, parm2 = c(1, 3, 5), parm3 = c(2, 4, 6)) # Survival function

}
\references{
Joe, H. (1997). \emph{Multivariate Models and Dependence Concepts}. London: Chapman & Hall.

Johnson, N. L. and Kotz, S. (1972). \emph{Distribution in Statistics: Continuous Multivariate Distributions}. New York: John Wiley & Sons, INC.

Nayak, T. K. (1987). Multivariate Lomax Distribution: Properties and Usefulness in Reliability Theory. \emph{Journal of Applied Probability}, Vol. 24, No. 1, 170-177.
}
\seealso{
\code{\link{uniroot}} for one dimensional root (zero) finding.
}
