% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActFunc.R
\name{Der3ActFunc}
\alias{Der3ActFunc}
\title{Third derivative of activation function of neuron}
\usage{
Der3ActFunc(type = "sigmoid", ...)
}
\arguments{
\item{type}{\code{character} name of the activation function}

\item{...}{extra arguments needed to calculate the functions}
}
\value{
\code{numeric} output of the neuron
}
\description{
Evaluate third derivative of activation function of a neuron
}
\examples{
# Return derivative of the sigmoid activation function of a neuron
ActivationFunction <- Der3ActFunc("sigmoid")
# Return derivative of the tanh activation function of a neuron
ActivationFunction <- Der3ActFunc("tanh")
# Return derivative of the activation function of several layers of neurons
actfuncs <- c("linear","sigmoid","linear")
ActivationFunctions <- sapply(actfuncs, Der3ActFunc)
}
