% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuralnetfilter.R
\name{neuralnetfilter}
\alias{neuralnetfilter}
\title{Neural Network Filter}
\usage{
neuralnetfilter(
  neuralarray,
  method = c("TMFG", "MaST", "ECOplusMaST", "ECO", "threshold"),
  progBar = TRUE,
  ...
)
}
\arguments{
\item{neuralarray}{Array from \code{\link{convertConnBrainMat}} function}

\item{method}{Filtering method to be applied}

\item{progBar}{Should progress bar be displayed?
Defaults to \code{TRUE}.
Set \code{FALSE} for no progress bar}

\item{...}{Additional arguments from network filtering methods}
}
\value{
Returns an array of n x n x m filtered matrices
}
\description{
Applies a network filtering methodology to neural network array.
Removes edges from the neural network output from \code{\link{convertConnBrainMat}} 
using a network filtering approach
}
\examples{
\dontrun{neuralarray <- convertConnBrainMat()

filteredneuralarray <- neuralnetfilter(neuralarray, method = "threshold", thresh = .50)

dependencyarray <- depna(neuralarray)

filtereddependencyarray <- neuralnetfilter(dependencyarray, method = "TMFG", depend = TRUE)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
