% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/closeness.R
\name{closeness}
\alias{closeness}
\title{Closeness Centrality}
\usage{
closeness(A, weighted = TRUE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to \code{TRUE}.
Set to \code{FALSE} for unweighted measure of closeness centrality}
}
\value{
A vector of closeness centrality values for each node in the network
}
\description{
Computes closeness centrality of each node in a network
}
\examples{
# Pearson's correlation only for CRAN checks
A <- TMFG(neoOpen, normal = FALSE)$A

#Weighted LC
LC <- closeness(A)

#Unweighted LC
LC <- closeness(A, weighted = FALSE)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{NeuroImage}, \emph{52}, 1059-1069.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
