% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{commboot}
\alias{commboot}
\title{Bootstrapped Communities Likelihood}
\usage{
commboot(data, normal = FALSE, n = nrow(data), iter = 1000,
  filter = c("TMFG", "threshold", "EBICglasso", "IsingFit"),
  method = c("louvain", "walktrap"), na.data = c("pairwise", "listwise",
  "fiml", "none"), steps = 4, cores, ...)
}
\arguments{
\item{data}{A set of data}

\item{normal}{Should data be transformed to a normal distribution?
Defaults to FALSE.
Data is not transformed to be normal.
Set to TRUE if data should be transformed to be normal}

\item{n}{Number of people to use in the bootstrap.
Defaults to full sample size}

\item{iter}{Number of bootstrap iterations.
Defaults to 100 iterations}

\item{filter}{Set filter method.
Defaults to "TMFG".
See \link[qgraph]{EBICglasso} and \code{\link{IsingFit}} for additional arguments}

\item{method}{Defaults to "walktrap".
Set to "louvain" for the louvain community detection algorithm}

\item{na.data}{How should missing data be handled?
For "listwise" deletion the \code{\link{na.omit}} function is applied.
Set to "fiml" for Full Information Maxmimum Likelihood (\link[psych]{corFiml}).
Full Information Maxmimum Likelihood is \strong{recommended} but time consuming}

\item{steps}{Number of steps to use in the walktrap algorithm.
Defaults to 4.
Use a larger number of steps for smaller networks}

\item{cores}{Number of computer processing cores to use for bootstrapping samples.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maxmimum amount of cores on your computer}

\item{...}{Additional arguments for network filtering methods}
}
\value{
Returns the number of factors and their relative frequency found across bootstrapped samples
}
\description{
Bootstraps the sample with replace to compute walktrap reliability
}
\examples{
\dontrun{
commTMFG<-commboot(neoOpen)

commThreshold<-commboot(neoOpen,filter="threshold")
}
}
\references{
Blondel, V. D., Guillaume, J. L., Lambiotte, R., & Lefebvre, E. (2008).
Fast unfolding of communities in large networks.
\emph{Journal of Statistical Mechanics: Theory and Experiment}, \emph{2008}(10), P10008.

Csardi, G., & Nepusz, T. (2006).
The igraph software package for complex network research.
\emph{InterJournal, Complex Systems}, \emph{1695}(5), 1-9.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
