% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{rspbc}
\alias{rspbc}
\title{Randomized Shortest Paths Betweenness Centrality}
\usage{
rspbc(A, beta = 0.01)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{beta}{Sets the beta parameter. Defaults to 0.01 (recommended). Beta > 0.01 measure gets closer to weighted betweenness centrality (10) and beta < 0.01 measure gets closer to degree (.0001)}
}
\value{
A vector of randomized shortest paths betweenness centrality values for each node in the network
}
\description{
Computes betweenness centrlaity based on randomized shortest paths of each node in a network
}
\examples{
A<-TMFG(hex)$A

rspbc<-rspbc(A, beta=0.01)
}
\references{
Kivimaki, I., Lebichot, B., Saramaki, J., & Saerens, M. (2016).
Two betweenness centrality measures based on Randomized Shortest Paths.
\emph{Scientific Reports}, \emph{6}(19668), 1-15.
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
