% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlicecdGammaPareto.R
\name{SlicedGammaParetoMean}
\alias{SlicedGammaParetoMean}
\title{Sliced Gamma Pareto mean}
\usage{
SlicedGammaParetoMean(GShape, GRate, SlicePoint, PShape)
}
\arguments{
\item{GShape}{A positive real number -  the shape parameter of the attritional Claim Severity's Gamma distribution.}

\item{GRate}{A positive real number -  the rate parameter of the attritional Claim Severity's Gamma distribution.}

\item{SlicePoint}{A positive real number - the slice point and the scale parameter of the tail Claim Severity's Pareto distribution.}

\item{PShape}{A positive real number - the Shape parameter of the tail Claim Severity's Pareto distribution.}
}
\value{
The mean of the claim severity with an attritional claim Gamma distribution with parameters \code{GShape} and \code{GRate} and a large claim Pareto distribution with parameters \code{SlicePoint} and \code{PShape}.
}
\description{
Sliced Gamma Pareto mean
}
\examples{
SlicedGammaParetoMean(1,0.0005,1000,1.2)
SlicedGammaParetoMean(1.1,0.0006,2000,1.6)
SlicedGammaParetoMean(1.2,0.0004,3000,1.4)
}
