% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/auxfuns.R
\name{.approxB}
\alias{.approxB}
\alias{.getZ}
\alias{auxfuns}
\alias{.cbind.fill}
\alias{.mpower}
\alias{.findPerm}
\alias{.transf}
\alias{.pi.hat}
\alias{.e.pi}
\title{Internal functions and generics for \code{mmsbm} package}
\usage{
.approxB(y, d_id, pi_mat)

.getZ(pi_mat)

.cbind.fill(...)

.mpower(mat, p)

.findPerm(block.list, target.mat = NULL, use.perms = TRUE)

.transf(mat)

.pi.hat(X, beta)

.e.pi(pi_l, kappa)
}
\arguments{
\item{y}{Numeric vector; vector of edge values.}

\item{d_id}{Integer matrix; two-column matrix with nr. dyads rows, containing zero-based
sender (first column) and receiver (second column) node id's for each dyad.}

\item{pi_mat}{Numeric matrix; row-stochastic matrix of mixed-memberships.}

\item{...}{Numeric vectors; vectors of potentially different length to be cbind-ed.}

\item{mat}{Numeric matrix}

\item{p}{Numeric scalar; power to raise matrix to.}

\item{block.list}{List of matrices; each element is a square, numeric matrix 
that defines a blockmodel,}

\item{target.mat}{Numeric matrix; reference blockmodel that those in block.list should 
be aligned to. Optional, defaults to \code{NULL}.}

\item{use.perms}{Boolean; should all row/column permutations be explored when
realigning matrices? defaults to \code{TRUE}.}

\item{X}{Numeric matrix; design matrix of monadic predictors.}

\item{beta}{Numeric array; array of coefficients associated with monadic predictors. 
It of dimensions Nr. Predictors by Nr. of Blocks by Nr. of HMM states.}

\item{pi_l}{List of mixed-membership matrices.}

\item{kappa}{Numeric matrix; matrix of marginal HMM state probabilities.}
}
\value{
See individual return section for each function:
\describe{
      \item{.cbind.fill}{Matrix of \code{cbind}'ed elements in \code{...}, with missing values in each vector filled with \code{NA}.}
      \item{.mpower}{Matrix; the result of raising \code{mat} to the \code{p} power.}
      \item{.findPerm}{List of permuted blockmodel matrices}
      \item{.transf}{Matrix with transformed mixed-membership vectors along its rows, s.t. no element is equal to 0.0 or 1.0.}
      \item{.pi.hat}{List of predicted mixed-membership matrices, one element per HMM state.}
      \item{.e.pi }{Matrix of expected mixed-membership vectors along its rows, with expectation computed over marginal 
                    distribution over HMM states for each time period.}
    }
}
\description{
These are various utilities and generic methods used by 
the main package function.
}
\details{
These functions are meant for internal use only.
}
\author{
Kosuke Imai (imai@harvard.edu), Tyler Pratt (tyler.pratt@yale.edu), Santiago Olivella (olivella@unc.edu)
}
